/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.embedded.AbstractEmbeddedCacheManagerFactory;
import org.infinispan.spring.embedded.provider.SpringEmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringEmbeddedCacheManagerFactoryBean
extends AbstractEmbeddedCacheManagerFactory
implements FactoryBean<SpringEmbeddedCacheManager>,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(SpringEmbeddedCacheManagerFactoryBean.class);
    private SpringEmbeddedCacheManager cacheManager;

    public void afterPropertiesSet() throws Exception {
        logger.info((Object)"Initializing SpringEmbeddedCacheManager instance ...");
        EmbeddedCacheManager nativeEmbeddedCacheManager = this.createBackingEmbeddedCacheManager();
        this.cacheManager = new SpringEmbeddedCacheManager(nativeEmbeddedCacheManager);
        logger.info((Object)("Successfully initialized SpringEmbeddedCacheManager instance [" + this.cacheManager + "]"));
    }

    public SpringEmbeddedCacheManager getObject() throws Exception {
        return this.cacheManager;
    }

    public Class<? extends SpringEmbeddedCacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : SpringEmbeddedCacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }
}

