/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded;

import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.util.NullValue;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.spring.common.session.MapSessionProtoAdapter;
import org.infinispan.spring.common.session.PersistenceContextInitializerImpl;
import org.springframework.session.MapSession;

@InfinispanModule(name="spring-embedded", requiredModules={"core"})
public class SpringEmbeddedModule
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        ClassAllowList serializationAllowList = gcr.getCacheManager().getClassAllowList();
        serializationAllowList.addClasses(new Class[]{NullValue.class});
        serializationAllowList.addRegexps(new String[]{"java.util\\..*", "org.springframework\\..*"});
        JavaSerializationMarshaller serializationMarshaller = new JavaSerializationMarshaller(serializationAllowList);
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        this.addSessionContextInitializerAndMarshaller(ctxRegistry, serializationMarshaller);
    }

    private void addSessionContextInitializerAndMarshaller(SerializationContextRegistry ctxRegistry, JavaSerializationMarshaller serializationMarshaller) {
        try {
            new MapSession();
        }
        catch (NoClassDefFoundError e) {
            Log.CONFIG.debug((Object)"spring-session classes not found, skipping the session context initializer registration");
            return;
        }
        PersistenceContextInitializerImpl sessionSci = new PersistenceContextInitializerImpl();
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)sessionSci);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)sessionSci);
        MapSessionProtoAdapter.SessionAttributeRawMarshaller sessionAttributeMarshaller = new MapSessionProtoAdapter.SessionAttributeRawMarshaller(serializationMarshaller);
        ctxRegistry.addMarshaller(SerializationContextRegistry.MarshallerType.PERSISTENCE, (BaseMarshaller)sessionAttributeMarshaller);
        ctxRegistry.addMarshaller(SerializationContextRegistry.MarshallerType.GLOBAL, (BaseMarshaller)sessionAttributeMarshaller);
    }
}

