/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote.actuator;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import org.infinispan.client.hotrod.RemoteCache;

public class RemoteInfinispanCacheMeterBinder
extends CacheMeterBinder {
    private final RemoteCache cache;

    public RemoteInfinispanCacheMeterBinder(RemoteCache cache, Iterable<Tag> tags) {
        super((Object)cache, cache.getName(), tags);
        this.cache = cache;
    }

    protected Long size() {
        return null;
    }

    protected long hitCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.clientStatistics().getRemoteHits();
    }

    protected Long missCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.clientStatistics().getRemoteMisses();
    }

    protected Long evictionCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.clientStatistics().getRemoteRemoves();
    }

    protected long putCount() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.clientStatistics().getRemoteStores();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.cache == null) {
            return;
        }
        Gauge.builder((String)"cache.reset", (Object)this.cache, cache -> cache.clientStatistics().getTimeSinceReset()).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description("Time elapsed in seconds since the last statistics reset").register(registry);
        this.averages(registry);
        this.nearCacheMetrics(registry);
    }

    private void averages(MeterRegistry registry) {
        Gauge.builder((String)"cache.puts.latency", (Object)this.cache, cache -> cache.clientStatistics().getAverageRemoteStoreTime()).tags(this.getTagsWithCacheName()).description("Cache puts").register(registry);
        Gauge.builder((String)"cache.gets.latency", (Object)this.cache, cache -> cache.clientStatistics().getAverageRemoteReadTime()).tags(this.getTagsWithCacheName()).description("Cache gets").register(registry);
        Gauge.builder((String)"cache.removes.latency", (Object)this.cache, cache -> cache.clientStatistics().getAverageRemoteRemovesTime()).tags(this.getTagsWithCacheName()).description("Cache removes").register(registry);
    }

    private void nearCacheMetrics(MeterRegistry registry) {
        if (this.isNearCacheEnabled()) {
            Gauge.builder((String)"cache.near.requests", (Object)this.cache, cache -> cache.clientStatistics().getNearCacheHits()).tags(this.getTagsWithCacheName()).tag("result", "hit").description("The number of hits (reads) of near cache entries owned by this client").register(registry);
            Gauge.builder((String)"cache.near.requests", (Object)this.cache, cache -> cache.clientStatistics().getNearCacheMisses()).tags(this.getTagsWithCacheName()).tag("result", "miss").description("The number of hits (reads) of near cache entries owned by this client").register(registry);
            Gauge.builder((String)"cache.near.invalidations", (Object)this.cache, cache -> cache.clientStatistics().getNearCacheInvalidations()).tags(this.getTagsWithCacheName()).description("The number of invalidations of near cache entries owned by this client").register(registry);
            Gauge.builder((String)"cache.near.size", (Object)this.cache, cache -> cache.clientStatistics().getNearCacheSize()).tags(this.getTagsWithCacheName()).description("The size of the near cache owned by this client").register(registry);
        }
    }

    private boolean isNearCacheEnabled() {
        return this.cache.getRemoteCacheContainer().getConfiguration().nearCache().mode().enabled();
    }
}

