/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheCustomizer;
import org.infinispan.spring.starter.remote.InfinispanRemoteConfigurationProperties;
import org.infinispan.spring.starter.remote.InfinispanRemoteConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@ComponentScan
@AutoConfigureBefore(value={CacheAutoConfiguration.class})
@ConditionalOnClass(name={"org.infinispan.client.hotrod.RemoteCacheManager"})
@ConditionalOnProperty(value={"infinispan.remote.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfinispanRemoteConfigurationProperties.class})
public class InfinispanRemoteAutoConfiguration {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
    public static final String REMOTE_CACHE_MANAGER_BEAN_QUALIFIER = "remoteCacheManager";
    @Autowired
    private InfinispanRemoteConfigurationProperties infinispanProperties;
    @Autowired(required=false)
    private InfinispanRemoteConfigurer infinispanRemoteConfigurer;
    @Autowired(required=false)
    private Configuration infinispanConfiguration;
    @Autowired(required=false)
    private List<InfinispanRemoteCacheCustomizer> cacheCustomizers = Collections.emptyList();
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @Conditional(value={ConditionalOnCacheType.class, ConditionalOnConfiguration.class})
    @ConditionalOnMissingBean
    @Qualifier(value="remoteCacheManager")
    public RemoteCacheManager remoteCacheManager() throws IOException {
        boolean hasHotRodPropertiesFile = this.ctx.getResource(this.infinispanProperties.getClientProperties()).exists();
        boolean hasConfigurer = this.infinispanRemoteConfigurer != null;
        boolean hasProperties = StringUtils.hasText((String)this.infinispanProperties.getServerList());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addJavaSerialAllowList(new String[]{"java.util.*", "java.time.*", "org.springframework.*", "org.infinispan.spring.common.*", "org.infinispan.spring.remote.*"});
        builder.marshaller((Marshaller)new JavaSerializationMarshaller());
        if (hasConfigurer) {
            builder.read(Objects.requireNonNull(this.infinispanRemoteConfigurer.getRemoteConfiguration()));
        } else if (hasHotRodPropertiesFile) {
            String remoteClientPropertiesLocation = this.infinispanProperties.getClientProperties();
            Resource hotRodClientPropertiesFile = this.ctx.getResource(remoteClientPropertiesLocation);
            try (InputStream stream = hotRodClientPropertiesFile.getURL().openStream();){
                Properties hotrodClientProperties = new Properties();
                hotrodClientProperties.load(stream);
                builder.withProperties(hotrodClientProperties);
            }
        } else if (hasProperties) {
            builder.withProperties(this.infinispanProperties.getProperties());
        } else if (this.infinispanConfiguration != null) {
            builder.read(this.infinispanConfiguration);
        } else {
            throw new IllegalStateException("Not enough data to create RemoteCacheManager. Check InfinispanRemoteCacheManagerCheckerand update conditions.");
        }
        this.cacheCustomizers.forEach(c -> c.customize(builder));
        return new RemoteCacheManager(builder.build());
    }

    public static class ConditionalOnConfigurationResources
    implements Condition {
        public boolean matches(ConditionContext ctx, AnnotatedTypeMetadata atm) {
            return this.hasHotRodClientPropertiesFile(ctx) || this.hasServersProperty(ctx);
        }

        private boolean hasServersProperty(ConditionContext conditionContext) {
            return conditionContext.getEnvironment().getProperty("infinispan.remote.server-list") != null;
        }

        private boolean hasHotRodClientPropertiesFile(ConditionContext conditionContext) {
            String hotRodPropertiesPath = conditionContext.getEnvironment().getProperty("infinispan.remote.client-properties");
            if (hotRodPropertiesPath == null) {
                hotRodPropertiesPath = "classpath:hotrod-client.properties";
            }
            return conditionContext.getResourceLoader().getResource(hotRodPropertiesPath).exists();
        }
    }

    public static class ConditionalOnCacheType
    implements Condition {
        public boolean matches(ConditionContext ctx, AnnotatedTypeMetadata atm) {
            String cacheType = ctx.getEnvironment().getProperty("spring.cache.type");
            return cacheType == null || CacheType.INFINISPAN.name().equalsIgnoreCase(cacheType);
        }
    }

    public static class ConditionalOnConfiguration
    extends AnyNestedCondition {
        public ConditionalOnConfiguration() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={Configuration.class})
        static class OnConfiguration {
            OnConfiguration() {
            }
        }

        @ConditionalOnBean(value={InfinispanRemoteConfigurer.class})
        static class OnRemoteConfigurer {
            OnRemoteConfigurer() {
            }
        }

        @Conditional(value={ConditionalOnConfigurationResources.class})
        static class OnConfigurationResources {
            OnConfigurationResources() {
            }
        }
    }
}

