/*
 * Decompiled with CFR 0.152.
 */
package infinispan.autoconfigure.remote;

import infinispan.autoconfigure.common.InfinispanProperties;
import infinispan.autoconfigure.remote.InfinispanRemoteConfigurer;
import infinispan.autoconfigure.remote.InfinispanRemoteFileChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;

@org.springframework.context.annotation.Configuration
@ComponentScan
@ConditionalOnClass(name={"org.infinispan.client.hotrod.RemoteCacheManager"})
@Conditional(value={InfinispanRemoteFileChecker.class})
@ConditionalOnProperty(value={"infinispan.remote.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfinispanProperties.class})
public class InfinispanRemoteAutoConfiguration {
    @Autowired
    private InfinispanProperties infinispanProperties;
    @Autowired(required=false)
    private InfinispanRemoteConfigurer infinispanRemoteConfigurer;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @Conditional(value={InfinispanRemoteFileChecker.class})
    public RemoteCacheManager remoteCacheManager() throws IOException {
        Configuration configuration;
        if (this.infinispanRemoteConfigurer != null) {
            configuration = this.infinispanRemoteConfigurer.getRemoteConfiguration();
        } else {
            String remoteClientPropertiesLocation = this.infinispanProperties.getRemote().getClientProperties();
            Resource hotRodClientPropertiesFile = this.ctx.getResource(remoteClientPropertiesLocation);
            Properties hotrodClientProperties = new Properties();
            try (InputStream stream = hotRodClientPropertiesFile.getURL().openStream();){
                hotrodClientProperties.load(stream);
                configuration = new ConfigurationBuilder().withProperties(hotrodClientProperties).build();
            }
        }
        return new RemoteCacheManager(configuration);
    }
}

