/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfiguration;

public class RealmsConfigurationBuilder
implements Builder<RealmsConfiguration> {
    private final Map<String, RealmConfigurationBuilder> securityRealms = new LinkedHashMap<String, RealmConfigurationBuilder>(2);

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public RealmConfigurationBuilder addSecurityRealm(String name) {
        RealmConfigurationBuilder realmConfigurationBuilder = new RealmConfigurationBuilder(name);
        this.securityRealms.put(name, realmConfigurationBuilder);
        return realmConfigurationBuilder;
    }

    public RealmsConfiguration create() {
        Map<String, RealmConfiguration> map = this.securityRealms.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((RealmConfigurationBuilder)e.getValue()).create()));
        return new RealmsConfiguration(map);
    }

    public RealmsConfigurationBuilder read(RealmsConfiguration template, Combine combine) {
        this.securityRealms.clear();
        template.realms().entrySet().forEach(e -> this.addSecurityRealm((String)e.getKey()).read((RealmConfiguration)((Object)((Object)e.getValue())), combine));
        return this;
    }

    public void validate() {
        this.securityRealms.values().forEach(RealmConfigurationBuilder::validate);
    }
}

