/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Util;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.AggregateRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.DistributedRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LocalRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.PropertiesRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.RealmProviderBuilder;
import org.infinispan.server.configuration.security.ServerIdentitiesConfigurationBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreRealmConfigurationBuilder;
import org.wildfly.security.auth.server.EvidenceDecoder;

public class RealmConfigurationBuilder
implements Builder<RealmConfiguration> {
    private final AttributeSet attributes;
    private final ServerIdentitiesConfigurationBuilder serverIdentitiesConfiguration = new ServerIdentitiesConfigurationBuilder(this);
    private final List<RealmProviderBuilder<?>> builders = new ArrayList();

    RealmConfigurationBuilder(String name) {
        this.attributes = RealmConfiguration.attributeDefinitionSet();
        this.attributes.attribute(RealmConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RealmConfigurationBuilder defaultRealm(String defaultRealm) {
        this.attributes.attribute(RealmConfiguration.DEFAULT_REALM).set((Object)defaultRealm);
        return this;
    }

    public RealmConfigurationBuilder cacheMaxSize(int size) {
        this.attributes.attribute(RealmConfiguration.CACHE_MAX_SIZE).set((Object)size);
        return this;
    }

    public RealmConfigurationBuilder cacheLifespan(long lifespan) {
        this.attributes.attribute(RealmConfiguration.CACHE_LIFESPAN).set((Object)lifespan);
        return this;
    }

    public RealmConfigurationBuilder evidenceDecoder(EvidenceDecoder evidenceDecoder) {
        this.attributes.attribute(RealmConfiguration.EVIDENCE_DECODER).set((Object)evidenceDecoder);
        return this;
    }

    public AggregateRealmConfigurationBuilder aggregateConfiguration() {
        return this.addBuilder(Element.AGGREGATE_REALM, new AggregateRealmConfigurationBuilder());
    }

    public DistributedRealmConfigurationBuilder distributedConfiguration() {
        return this.addBuilder(Element.DISTRIBUTED_REALM, new DistributedRealmConfigurationBuilder());
    }

    public LdapRealmConfigurationBuilder ldapConfiguration() {
        return this.addBuilder(Element.LDAP_REALM, new LdapRealmConfigurationBuilder());
    }

    public LocalRealmConfigurationBuilder localConfiguration() {
        return this.addBuilder(Element.LOCAL_REALM, new LocalRealmConfigurationBuilder());
    }

    public TokenRealmConfigurationBuilder tokenConfiguration() {
        return this.addBuilder(Element.TOKEN_REALM, new TokenRealmConfigurationBuilder());
    }

    public TrustStoreRealmConfigurationBuilder trustStoreConfiguration() {
        return this.addBuilder(Element.TRUSTSTORE_REALM, new TrustStoreRealmConfigurationBuilder());
    }

    public PropertiesRealmConfigurationBuilder propertiesConfiguration() {
        return this.addBuilder(Element.PROPERTIES_REALM, new PropertiesRealmConfigurationBuilder());
    }

    public ServerIdentitiesConfigurationBuilder serverIdentitiesConfiguration() {
        return this.serverIdentitiesConfiguration;
    }

    private <T extends RealmProviderBuilder> T addBuilder(Enum<?> type, T builder) {
        for (RealmProviderBuilder<?> b : this.builders) {
            if (!b.getClass().equals(builder.getClass())) continue;
            throw Server.log.duplicateRealmType(type.toString(), (String)this.attributes.attribute(RealmConfiguration.NAME).get());
        }
        this.builders.add(builder);
        return builder;
    }

    public void validate() {
        this.serverIdentitiesConfiguration.validate();
        HashSet names = new HashSet();
        for (RealmProviderBuilder<?> builder : this.builders) {
            if (names.contains(builder.name())) {
                throw Server.log.duplicateRealm(builder.name());
            }
            builder.validate();
        }
    }

    public RealmConfiguration create() {
        Collections.sort(this.builders);
        return new RealmConfiguration(this.attributes.protect(), this.serverIdentitiesConfiguration.create(), this.builders.stream().map(Builder::create).collect(Collectors.toList()));
    }

    public RealmConfigurationBuilder read(RealmConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.serverIdentitiesConfiguration.read(template.serverIdentitiesConfiguration(), combine);
        this.builders.clear();
        for (RealmProvider provider : template.realmProviders()) {
            RealmProviderBuilder builder = (RealmProviderBuilder)Util.getInstance(provider.getClass().getAnnotation(BuiltBy.class).value().asSubclass(RealmProviderBuilder.class));
            builder.read(provider, combine);
            this.builders.add(builder);
        }
        return this;
    }
}

