/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.rest;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.configuration.CorsConfigurationBuilder;
import org.infinispan.rest.configuration.CorsRuleConfigurationBuilder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestAuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.endpoint.EndpointConfigurationBuilder;
import org.infinispan.server.configuration.rest.Attribute;
import org.infinispan.server.configuration.rest.Element;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.SniConfigurationBuilder;
import org.infinispan.server.security.ElytronHTTPAuthenticator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="rest-connector"), @Namespace(uri="urn:infinispan:server:*", root="rest-connector")})
public class RestServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REST_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseRest(reader, serverBuilder);
                    break;
                }
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseRest(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder) {
        boolean dedicatedSocketBinding = false;
        String securityRealm = null;
        EndpointConfigurationBuilder endpoint = serverBuilder.endpoints().current();
        RestServerConfigurationBuilder builder = endpoint.addConnector(RestServerConfigurationBuilder.class);
        ServerConfigurationParser.configureEndpoint(reader.getProperties(), endpoint, builder);
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CONTEXT_PATH: {
                    builder.contextPath(value);
                    continue block14;
                }
                case EXTENDED_HEADERS: {
                    builder.extendedHeaders((ExtendedHeaders)ParseUtils.parseEnum((ConfigurationReader)reader, (int)i, ExtendedHeaders.class, (String)value));
                    continue block14;
                }
                case NAME: {
                    builder.name(value);
                    continue block14;
                }
                case MAX_CONTENT_LENGTH: {
                    builder.maxContentLength(ParseUtils.parseInt((ConfigurationReader)reader, (int)i, (String)value).intValue());
                    continue block14;
                }
                case COMPRESSION_LEVEL: {
                    builder.compressionLevel(ParseUtils.parseInt((ConfigurationReader)reader, (int)i, (String)value).intValue());
                    continue block14;
                }
                case SOCKET_BINDING: {
                    builder.socketBinding(value);
                    builder.startTransport(true);
                    dedicatedSocketBinding = true;
                    continue block14;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        if (!dedicatedSocketBinding) {
            ((RestServerConfigurationBuilder)builder.socketBinding(endpoint.singlePort().socketBinding())).startTransport(false);
        }
        block15: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable(), securityRealm);
                    continue block15;
                }
                case ENCRYPTION: {
                    if (!dedicatedSocketBinding) {
                        throw Server.log.cannotConfigureProtocolEncryptionUnderSinglePort();
                    }
                    this.parseEncryption(reader, serverBuilder, builder.encryption(), securityRealm);
                    continue block15;
                }
                case CORS_RULES: {
                    this.parseCorsRules(reader, builder);
                    continue block15;
                }
            }
            ServerConfigurationParser.parseCommonConnectorElements(reader, builder);
        }
    }

    private void parseCorsRules(ConfigurationReader reader, RestServerConfigurationBuilder builder) {
        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
        CorsConfigurationBuilder cors = builder.cors();
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CORS_RULES: 
                case CORS_RULE: {
                    this.parseCorsRule(reader, cors.addNewRule());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseCorsRule(ConfigurationReader reader, CorsRuleConfigurationBuilder corsRule) {
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    corsRule.name(value);
                    continue block15;
                }
                case ALLOW_CREDENTIALS: {
                    corsRule.allowCredentials(Boolean.parseBoolean(value));
                    continue block15;
                }
                case MAX_AGE_SECONDS: {
                    corsRule.maxAge(Long.parseLong(value));
                    continue block15;
                }
                case ALLOWED_HEADERS: {
                    corsRule.allowHeaders(reader.getListAttributeValue(i));
                    continue block15;
                }
                case ALLOWED_ORIGINS: {
                    corsRule.allowOrigins(reader.getListAttributeValue(i));
                    continue block15;
                }
                case ALLOWED_METHODS: {
                    corsRule.allowMethods(reader.getListAttributeValue(i));
                    continue block15;
                }
                case EXPOSE_HEADERS: {
                    corsRule.exposeHeaders(reader.getListAttributeValue(i));
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (reader.getSchema().since(13, 0)) {
            ParseUtils.requireNoContent((ConfigurationReader)reader);
        } else {
            block16: while (reader.inTag()) {
                Element element = Element.forName(reader.getLocalName());
                String[] values = reader.getElementText().split(",");
                switch (element) {
                    case ALLOWED_HEADERS: {
                        corsRule.allowHeaders(values);
                        continue block16;
                    }
                    case ALLOWED_ORIGINS: {
                        corsRule.allowOrigins(values);
                        continue block16;
                    }
                    case ALLOWED_METHODS: {
                        corsRule.allowMethods(values);
                        continue block16;
                    }
                    case EXPOSE_HEADERS: {
                        corsRule.exposeHeaders(values);
                        continue block16;
                    }
                }
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseAuthentication(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, RestAuthenticationConfigurationBuilder builder, String securityRealmName) {
        if (securityRealmName == null) {
            securityRealmName = serverBuilder.endpoints().current().securityRealm();
        }
        String serverPrincipal = null;
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    builder.securityRealm(value);
                    securityRealmName = value;
                    continue block5;
                }
                case MECHANISMS: {
                    builder.addMechanisms(reader.getListAttributeValue(i));
                    continue block5;
                }
                case SERVER_PRINCIPAL: {
                    serverPrincipal = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
        if (securityRealmName == null) {
            throw Server.log.authenticationWithoutSecurityRealm();
        }
        builder.authenticator((RestAuthenticator)new ElytronHTTPAuthenticator(securityRealmName, serverPrincipal, builder.mechanisms()));
    }

    private void parseEncryption(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, EncryptionConfigurationBuilder encryption, String securityRealmName) {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    encryption.requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    securityRealmName = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (securityRealmName == null) {
            throw Server.log.encryptionWithoutSecurityRealm();
        }
        encryption.realm(securityRealmName).sslContext(serverBuilder.serverSSLContextSupplier(securityRealmName));
        block8: while (reader.inTag((Enum)Element.ENCRYPTION)) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    if (reader.getAttributeCount() <= 0) continue block8;
                    this.parseSni(reader, serverBuilder, encryption.addSni());
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseSni(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, SniConfigurationBuilder sni) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case HOST_NAME: {
                    sni.host(value);
                    continue block4;
                }
                case SECURITY_REALM: {
                    sni.realm(value);
                    sni.sslContext(serverBuilder.serverSSLContextSupplier(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }
}

