/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.sasl.SaslServer;
import org.infinispan.server.core.security.AuthorizingCallbackHandler;
import org.infinispan.server.core.security.SubjectSaslServer;
import org.infinispan.server.security.RolePrincipal;
import org.wildfly.security.auth.server.SecurityIdentity;

class ElytronSubjectSaslServer
extends SubjectSaslServer {
    public ElytronSubjectSaslServer(SaslServer delegate, List<Principal> principals, AuthorizingCallbackHandler callbackHandler) {
        super(delegate, principals, callbackHandler);
    }

    public Object getNegotiatedProperty(String propName) {
        if ("org.infinispan.security.Subject".equals(propName)) {
            if (this.isComplete()) {
                SecurityIdentity identity = (SecurityIdentity)this.delegate.getNegotiatedProperty("wildfly.sasl.security-identity");
                Subject subject = new Subject();
                Set<Principal> principals = subject.getPrincipals();
                if (!identity.isAnonymous()) {
                    principals.add(identity.getPrincipal());
                }
                identity.getRoles().forEach(role -> principals.add(new RolePrincipal((String)role)));
                principals.addAll(this.principals);
                return subject;
            }
            throw new IllegalStateException("Authentication is not complete");
        }
        return this.delegate.getNegotiatedProperty(propName);
    }
}

