/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging.events;

import java.time.Instant;
import java.util.Optional;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.impl.BaseEventLog;

@ProtoTypeId(value=5200)
public final class ServerEventImpl
extends BaseEventLog {
    @ProtoFactory
    ServerEventImpl(long whenMs, EventLogLevel level, EventLogCategory category, String message, String detail, String context, String who, String scope) {
        this(Instant.ofEpochMilli(whenMs), level, category, message, detail, context, who, scope);
    }

    ServerEventImpl(Instant when, EventLogLevel level, EventLogCategory category, String message, String detail, String context, String who, String scope) {
        super(when, level, category, message, detail, context, who, scope);
    }

    ServerEventImpl(Instant when, EventLogLevel level, EventLogCategory category, String message) {
        this(when, level, category, message, null, null, null, null);
    }

    @ProtoField(number=1, name="when", defaultValue="0")
    long getWhenMs() {
        return this.when.toEpochMilli();
    }

    @ProtoField(value=2)
    public EventLogLevel getLevel() {
        return this.level;
    }

    @ProtoField(value=3)
    public EventLogCategory getCategory() {
        return this.category;
    }

    @ProtoField(value=4)
    public String getMessage() {
        return this.message;
    }

    @ProtoField(value=5)
    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    @ProtoField(value=6)
    public Optional<String> getWho() {
        return Optional.ofNullable(this.who);
    }

    @ProtoField(value=7)
    public Optional<String> getContext() {
        return Optional.ofNullable(this.context);
    }

    @ProtoField(value=8)
    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public String toString() {
        return "ServerEventImpl{when=" + this.when + ", level=" + this.level + ", category=" + this.category + ", message='" + this.message + "', detail=" + this.detail + ", context=" + this.context + ", who=" + this.who + ", scope=" + this.scope + "}";
    }
}

