/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.util.Util;
import org.infinispan.server.logging.Log;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.TaskInstantiationMode;
import org.infinispan.util.logging.LogFactory;

public class ServerTaskWrapper<T>
implements Task {
    private static final Log log = (Log)LogFactory.getLog(ServerTaskWrapper.class, Log.class);
    private final ServerTask<T> task;

    public ServerTaskWrapper(ServerTask<T> task) {
        this.task = task;
    }

    public String getName() {
        return this.task.getName();
    }

    public T run(TaskContext context) throws Exception {
        ServerTask t = this.task.getInstantiationMode() == TaskInstantiationMode.ISOLATED ? (ServerTask)Util.getInstance(this.task.getClass()) : this.task;
        t.setTaskContext(context);
        if (log.isTraceEnabled()) {
            log.tracef("Executing task '%s' in '%s' mode using context %s", this.getName(), this.getInstantiationMode(), context);
        }
        return (T)t.call();
    }

    public String getType() {
        return "Java";
    }

    public TaskExecutionMode getExecutionMode() {
        return this.task.getExecutionMode();
    }

    public TaskInstantiationMode getInstantiationMode() {
        return this.task.getInstantiationMode();
    }

    public Optional<String> getRole() {
        return this.task.getAllowedRole();
    }

    public Set<String> getParameters() {
        return this.task.getParameters();
    }
}

