/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.scripting.utils.ScriptConversions;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.server.tasks.DistributedServerTaskRunner;
import org.infinispan.server.tasks.LocalServerTaskRunner;
import org.infinispan.server.tasks.PersistenceContextInitializerImpl;
import org.infinispan.server.tasks.SecurityActions;
import org.infinispan.server.tasks.ServerTaskRunner;
import org.infinispan.server.tasks.ServerTaskWrapper;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.concurrent.BlockingManager;

public class ServerTaskEngine
implements TaskEngine {
    private final LocalServerTaskRunner localRunner;
    private final DistributedServerTaskRunner distributedRunner;
    private final Authorizer globalauthorizer;
    private final ScriptConversions scriptConversions;
    private final Map<String, ServerTaskWrapper> tasks;

    public ServerTaskEngine(EmbeddedCacheManager cacheManager, Map<String, ServerTaskWrapper> tasks) {
        GlobalComponentRegistry registry = SecurityActions.getGlobalComponentRegistry(cacheManager);
        registry.registerComponent((Object)this, ServerTaskEngine.class);
        SerializationContextRegistry serializationContextRegistry = (SerializationContextRegistry)registry.getComponent(SerializationContextRegistry.class);
        serializationContextRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        EncoderRegistry encoderRegistry = (EncoderRegistry)registry.getComponent(EncoderRegistry.class);
        this.scriptConversions = new ScriptConversions(encoderRegistry);
        this.globalauthorizer = (Authorizer)registry.getComponent(Authorizer.class);
        this.tasks = tasks;
        this.localRunner = new LocalServerTaskRunner(this);
        this.distributedRunner = new DistributedServerTaskRunner();
    }

    public String getName() {
        return "Deployed";
    }

    public List<Task> getTasks() {
        return new ArrayList<Task>(this.tasks.values());
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context, BlockingManager blockingManager) {
        ServerTaskWrapper task = this.tasks.get(taskName);
        if (task == null) {
            throw new IllegalArgumentException("Task not found: " + taskName);
        }
        this.checkPermissions(context, task);
        return this.invokeTask(context, task);
    }

    private <T> CompletableFuture<T> invokeTask(TaskContext context, ServerTaskWrapper<T> task) {
        ServerTaskRunner runner = task.getExecutionMode() == TaskExecutionMode.ONE_NODE ? this.localRunner : this.distributedRunner;
        this.launderParameters(context);
        MediaType requestMediaType = context.getCache().map(c -> c.getAdvancedCache().getValueDataConversion().getRequestMediaType()).orElse(MediaType.MATCH_ALL);
        context.getCache().ifPresent(c -> context.cache((Cache)c.getAdvancedCache().withMediaType(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OBJECT)));
        return runner.execute(task.getName(), context).thenApply(r -> this.scriptConversions.convertToRequestType(r, MediaType.APPLICATION_OBJECT, requestMediaType));
    }

    private void launderParameters(TaskContext context) {
        if (context.getParameters().isPresent()) {
            Map convertParameters = this.scriptConversions.convertParameters(context);
            context.parameters(convertParameters);
        }
    }

    private <T> void checkPermissions(TaskContext context, ServerTaskWrapper<T> task) {
        String role = task.getRole().orElse(null);
        if (this.globalauthorizer != null) {
            AuthorizationManager authorizationManager;
            if (context.getCache().isPresent() && (authorizationManager = SecurityActions.getAuthorizationManager(((Cache)context.getCache().get()).getAdvancedCache())) != null) {
                authorizationManager.checkPermission(AuthorizationPermission.EXEC, role);
                return;
            }
            if (context.getSubject().isPresent()) {
                this.globalauthorizer.checkPermission((Subject)context.getSubject().get(), AuthorizationPermission.EXEC);
                return;
            }
            this.globalauthorizer.checkPermission(null, null, AuthorizationPermission.EXEC, role);
        }
    }

    public boolean handles(String taskName) {
        return this.tasks.containsKey(taskName);
    }

    public <T> ServerTaskWrapper<T> getTask(String taskName) {
        return this.tasks.get(taskName);
    }
}

