/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.security.PasswordCredentialSource;
import org.wildfly.security.credential.source.CredentialSource;

public class KeyStoreConfigurationBuilder
implements Builder<KeyStoreConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;

    KeyStoreConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = KeyStoreConfiguration.attributeDefinitionSet();
    }

    public KeyStoreConfigurationBuilder alias(String alias) {
        this.attributes.attribute(KeyStoreConfiguration.ALIAS).set((Object)alias);
        return this;
    }

    public KeyStoreConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_PASSWORD).set((Object)new PasswordCredentialSource(keyStorePassword));
        return this;
    }

    public KeyStoreConfigurationBuilder keyStorePassword(Supplier<CredentialSource> keyStorePassword) {
        this.attributes.attribute(KeyStoreConfiguration.KEYSTORE_PASSWORD).set(keyStorePassword);
        return this;
    }

    public KeyStoreConfigurationBuilder generateSelfSignedCertificateHost(String certificateHost) {
        this.attributes.attribute(KeyStoreConfiguration.GENERATE_SELF_SIGNED_CERTIFICATE_HOST).set((Object)certificateHost);
        return this;
    }

    @Deprecated
    public KeyStoreConfigurationBuilder keyPassword(char[] keyPassword) {
        this.attributes.attribute(KeyStoreConfiguration.KEY_PASSWORD).set((Object)new PasswordCredentialSource(keyPassword));
        return this;
    }

    public KeyStoreConfigurationBuilder path(String path) {
        this.attributes.attribute(KeyStoreConfiguration.PATH).set((Object)path);
        return this;
    }

    public KeyStoreConfigurationBuilder provider(String value) {
        this.attributes.attribute(KeyStoreConfiguration.PROVIDER).set((Object)value);
        return this;
    }

    public KeyStoreConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(KeyStoreConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public KeyStoreConfigurationBuilder type(String value) {
        this.attributes.attribute(KeyStoreConfiguration.TYPE).set((Object)value);
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(KeyStoreConfiguration.PATH).isNull() && this.attributes.attribute(KeyStoreConfiguration.TYPE).isNull()) {
            throw Server.log.filelessKeyStoreRequiresType();
        }
    }

    public KeyStoreConfiguration create() {
        return new KeyStoreConfiguration(this.attributes.protect());
    }

    public KeyStoreConfigurationBuilder read(KeyStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

