/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.ssl.SSLContextBuilder;

public class TrustStoreConfiguration
extends ConfigurationElement<TrustStoreConfiguration> {
    static final AttributeDefinition<Supplier<CredentialSource>> PASSWORD = AttributeDefinition.builder((Enum)Attribute.PASSWORD, null, Supplier.class).serializer(ServerConfigurationSerializer.CREDENTIAL).build();
    static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();
    static final AttributeDefinition<String> PROVIDER = AttributeDefinition.builder((Enum)Attribute.PROVIDER, null, String.class).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TrustStoreConfiguration.class, new AttributeDefinition[]{PATH, RELATIVE_TO, PROVIDER, PASSWORD});
    }

    TrustStoreConfiguration(AttributeSet attributes) {
        super((Enum)Element.TRUSTSTORE, attributes, new ConfigurationElement[0]);
    }

    KeyStore trustStore(Properties properties) {
        KeyStore keyStore;
        String fileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(PATH).get()), (String)properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get()));
        if (fileName == null) {
            return null;
        }
        String provider = (String)this.attributes.attribute(PROVIDER).get();
        char[] password = CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(PASSWORD));
        FileInputStream is = new FileInputStream(fileName);
        try {
            keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, (String)provider, (FileInputStream)is, (String)fileName, (char[])password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException e) {
                throw new CacheConfigurationException(e);
            }
        }
        is.close();
        return keyStore;
    }

    public void build(SSLContextBuilder builder, Properties properties) {
        try {
            KeyStore trustStore = this.trustStore(properties);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                builder.setTrustManager((X509TrustManager)trustManager);
                return;
            }
            throw Server.log.noDefaultTrustManager();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }
}

