/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.infinispan.server.configuration.security.CredentialStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.wildfly.security.credential.source.CredentialSource;

public class CredentialStoresConfigurationBuilder
implements Builder<CredentialStoresConfiguration> {
    private final AttributeSet attributes;
    private final Map<String, CredentialStoreConfigurationBuilder> credentialStores = new LinkedHashMap<String, CredentialStoreConfigurationBuilder>(2);
    private final List<CredentialStoreSourceSupplier> suppliers = new ArrayList<CredentialStoreSourceSupplier>();
    private final ServerConfigurationBuilder builder;

    public CredentialStoresConfigurationBuilder(ServerConfigurationBuilder builder) {
        this.builder = builder;
        this.attributes = CredentialStoresConfiguration.attributeDefinitionSet();
    }

    public CredentialStoreConfigurationBuilder addCredentialStore(String name) {
        CredentialStoreConfigurationBuilder credentialStoreBuilder = new CredentialStoreConfigurationBuilder(name);
        this.credentialStores.put(name, credentialStoreBuilder);
        return credentialStoreBuilder;
    }

    public CredentialStoresConfiguration create() {
        Map<String, CredentialStoreConfiguration> map = this.credentialStores.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((CredentialStoreConfigurationBuilder)e.getValue()).create()));
        CredentialStoresConfiguration configuration = new CredentialStoresConfiguration(this.attributes.protect(), map, this.builder.properties());
        for (CredentialStoreSourceSupplier s : this.suppliers) {
            s.configuration = configuration;
        }
        return configuration;
    }

    public Builder<?> read(CredentialStoresConfiguration template) {
        this.credentialStores.clear();
        template.credentialStores().forEach((k, v) -> this.addCredentialStore((String)k).read((CredentialStoreConfiguration)((Object)v)));
        return this;
    }

    public Supplier<CredentialSource> getCredential(String store, String alias) {
        CredentialStoreSourceSupplier credentialSupplier = new CredentialStoreSourceSupplier(store, alias);
        this.suppliers.add(credentialSupplier);
        return credentialSupplier;
    }

    public static class CredentialStoreSourceSupplier
    implements Supplier<CredentialSource> {
        final String store;
        final String alias;
        CredentialStoresConfiguration configuration;

        CredentialStoreSourceSupplier(String store, String alias) {
            this.store = store;
            this.alias = alias;
        }

        @Override
        public CredentialSource get() {
            return this.configuration.getCredentialSource(this.store, this.alias);
        }

        public String getStore() {
            return this.store;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

