/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.wildfly.security.credential.source.CredentialSource;

public class CredentialStoreConfigurationBuilder
implements Builder<CredentialStoreConfiguration> {
    private final AttributeSet attributes = CredentialStoreConfiguration.attributeDefinitionSet();

    CredentialStoreConfigurationBuilder(String name) {
        this.attributes.attribute(CredentialStoreConfiguration.NAME).set((Object)name);
    }

    public CredentialStoreConfigurationBuilder path(String value) {
        this.attributes.attribute(CredentialStoreConfiguration.PATH).set((Object)value);
        return this;
    }

    public CredentialStoreConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(CredentialStoreConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public CredentialStoreConfigurationBuilder type(String type) {
        this.attributes.attribute(CredentialStoreConfiguration.TYPE).set((Object)type);
        return this;
    }

    public CredentialStoreConfigurationBuilder credential(Supplier<CredentialSource> credential) {
        this.attributes.attribute(CredentialStoreConfiguration.CREDENTIAL).set(credential);
        return this;
    }

    public CredentialStoreConfiguration create() {
        return new CredentialStoreConfiguration(this.attributes.protect());
    }

    public Builder<?> read(CredentialStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

