/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.realm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.server.Server;
import org.infinispan.server.security.ElytronPasswordProviderSupplier;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;

public class EncryptedPropertiesSecurityRealm
implements CacheableSecurityRealm {
    private static final String COMMENT_PREFIX1 = "#";
    private static final String COMMENT_PREFIX2 = "!";
    private static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    private static final String COMMENT_SUFFIX = "$";
    private static final String ALGORITHM_COMMENT_PREFIX = "$ALGORITHM=";
    private final Supplier<Provider[]> providers;
    private final String defaultRealm;
    private final boolean plainText;
    private final String groupsAttribute;
    private final AtomicReference<LoadedState> loadedState = new AtomicReference();
    private Set<Consumer<Principal>> listeners = new LinkedHashSet<Consumer<Principal>>();

    private EncryptedPropertiesSecurityRealm(Builder builder) {
        this.plainText = builder.plainText;
        this.groupsAttribute = builder.groupsAttribute;
        this.providers = ElytronPasswordProviderSupplier.INSTANCE;
        this.defaultRealm = builder.defaultRealm;
        try {
            this.load(null, null);
        }
        catch (IOException e) {
            Server.log.debugf(e, "Error while loading properties", new Object[0]);
        }
    }

    public RealmIdentity getRealmIdentity(final Principal principal) {
        if (!(principal instanceof NamePrincipal)) {
            Server.log.tracef("PropertiesRealm: unsupported principal type: [%s]", principal);
            return RealmIdentity.NON_EXISTENT;
        }
        LoadedState loadedState = this.loadedState.get();
        final AccountEntry accountEntry = loadedState.getAccounts().get(principal.getName());
        if (accountEntry == null) {
            Server.log.tracef("PropertiesRealm: identity [%s] does not exist", principal);
            return RealmIdentity.NON_EXISTENT;
        }
        return new RealmIdentity(){

            public Principal getRealmIdentityPrincipal() {
                return principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
                for (Credential credential : accountEntry.getCredentials()) {
                    if (credential == null || !credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                    return SupportLevel.SUPPORTED;
                }
                return SupportLevel.UNSUPPORTED;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) {
                for (Credential credential : accountEntry.getCredentials()) {
                    if (credential == null || !credential.canVerify(evidenceType, algorithmName)) continue;
                    return SupportLevel.SUPPORTED;
                }
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) {
                return this.getCredential(credentialType, null);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
                return this.getCredential(credentialType, algorithmName, null);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
                for (Credential credential : accountEntry.getCredentials()) {
                    if (credential == null || !credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                    return (C)((Credential)credentialType.cast(credential.clone()));
                }
                return null;
            }

            public boolean verifyEvidence(Evidence evidence) {
                for (Credential credential : accountEntry.getCredentials()) {
                    if (credential == null || !credential.canVerify(evidence)) continue;
                    return credential.verify(evidence);
                }
                Server.log.tracef("Unable to verify evidence for identity [%s]", principal);
                return false;
            }

            public boolean exists() {
                return true;
            }

            public AuthorizationIdentity getAuthorizationIdentity() {
                return AuthorizationIdentity.basicIdentity((Attributes)new MapAttributes(Collections.singletonMap(EncryptedPropertiesSecurityRealm.this.groupsAttribute, accountEntry.getGroups())));
            }
        };
    }

    private PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance((String)algorithm, this.providers);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return PasswordCredential.class.isAssignableFrom(credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) {
        return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    /*
     * WARNING - void declaration
     */
    public void load(InputStream usersStream, InputStream groupsStream) throws IOException {
        HashMap<String, AccountEntry> accounts = new HashMap<String, AccountEntry>();
        Properties groups = new Properties();
        if (groupsStream != null) {
            try (InputStreamReader is = new InputStreamReader(groupsStream, StandardCharsets.UTF_8);){
                groups.load(is);
            }
        }
        long loadTime = 0L;
        String realmName = null;
        String algorithm = "clear";
        if (usersStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(usersStream, StandardCharsets.UTF_8));){
                String currentLine;
                while ((currentLine = reader.readLine()) != null) {
                    void var17_31;
                    String trimmed = currentLine.trim();
                    if (trimmed.startsWith(COMMENT_PREFIX1) && trimmed.contains(REALM_COMMENT_PREFIX)) {
                        int start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length();
                        int end = trimmed.indexOf(COMMENT_SUFFIX, start);
                        if (end <= -1) continue;
                        realmName = trimmed.substring(start, end);
                        continue;
                    }
                    if (trimmed.startsWith(COMMENT_PREFIX1) && trimmed.contains(ALGORITHM_COMMENT_PREFIX)) {
                        int start = trimmed.indexOf(ALGORITHM_COMMENT_PREFIX) + ALGORITHM_COMMENT_PREFIX.length();
                        int end = trimmed.indexOf(COMMENT_SUFFIX, start);
                        if (end <= -1) continue;
                        algorithm = trimmed.substring(start, end);
                        continue;
                    }
                    if (trimmed.startsWith(COMMENT_PREFIX1) || trimmed.startsWith(COMMENT_PREFIX2)) continue;
                    String username = null;
                    StringBuilder builder = new StringBuilder();
                    CodePointIterator it = CodePointIterator.ofString((String)trimmed);
                    while (it.hasNext()) {
                        int cp = it.next();
                        if (cp == 92 && it.hasNext()) {
                            int marker = it.next();
                            if (marker != 117) {
                                builder.appendCodePoint(marker);
                                continue;
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            try {
                                stringBuilder.appendCodePoint(it.next());
                                stringBuilder.appendCodePoint(it.next());
                                stringBuilder.appendCodePoint(it.next());
                                stringBuilder.appendCodePoint(it.next());
                                builder.appendCodePoint((char)Integer.parseInt(stringBuilder.toString(), 16));
                                continue;
                            }
                            catch (NoSuchElementException nsee) {
                                throw Server.log.invalidUnicodeSequence(stringBuilder.toString(), nsee);
                            }
                        }
                        if (username == null && (cp == 61 || cp == 58)) {
                            username = builder.toString().trim();
                            builder = new StringBuilder();
                            continue;
                        }
                        builder.appendCodePoint(cp);
                    }
                    if (username == null) continue;
                    ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
                    String string = algorithm;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1613773252: {
                            if (!string.equals("encrypted")) break;
                            boolean bl = false;
                            break;
                        }
                        case 94746189: {
                            if (!string.equals("clear")) break;
                            boolean bl = true;
                        }
                    }
                    switch (var17_31) {
                        case 0: {
                            String[] passwords;
                            for (String password : passwords = builder.toString().trim().split(";")) {
                                int colon = password.indexOf(58);
                                byte[] passwordBytes = CodePointIterator.ofChars((char[])password.substring(colon + 1).toCharArray()).base64Decode().drain();
                                PasswordFactory factory = this.getPasswordFactory(password.substring(0, colon));
                                PasswordSpec passwordSpec = BasicPasswordSpecEncoding.decode((byte[])passwordBytes);
                                try {
                                    credentials.add(new PasswordCredential(factory.generatePassword((KeySpec)passwordSpec)));
                                }
                                catch (InvalidKeySpecException e) {
                                    throw new IOException(e);
                                }
                            }
                            break;
                        }
                        case 1: {
                            PasswordFactory factory = this.getPasswordFactory("clear");
                            try {
                                credentials.add(new PasswordCredential(factory.generatePassword((KeySpec)new ClearPasswordSpec(builder.toString().trim().toCharArray()))));
                                break;
                            }
                            catch (InvalidKeySpecException e) {
                                throw new IOException(e);
                            }
                        }
                    }
                    accounts.put(username, new AccountEntry(username, credentials, groups.getProperty(username)));
                    for (Consumer consumer : this.listeners) {
                        consumer.accept(new NamePrincipal(username));
                    }
                }
            }
            if (realmName == null) {
                if (this.defaultRealm != null || this.plainText) {
                    realmName = this.defaultRealm;
                } else {
                    throw Server.log.noRealmFoundInProperties();
                }
            }
            loadTime = System.currentTimeMillis();
        }
        for (String userName : groups.stringPropertyNames()) {
            if (accounts.containsKey(userName)) continue;
            accounts.put(userName, new AccountEntry(userName, null, groups.getProperty(userName)));
        }
        this.loadedState.set(new LoadedState(accounts, realmName, loadTime));
    }

    public long getLoadTime() {
        return this.loadedState.get().getLoadTime();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void registerIdentityChangeListener(Consumer<Principal> listener) {
        this.listeners.add(listener);
    }

    private static class AccountEntry {
        private final String name;
        private final List<Credential> credentials;
        private final Set<String> groups;

        private AccountEntry(String name, List<Credential> credentials, String groups) {
            this.name = name;
            this.credentials = credentials;
            this.groups = this.convertGroups(groups);
        }

        private Set<String> convertGroups(String groups) {
            if (groups == null) {
                return Collections.emptySet();
            }
            return Arrays.stream(groups.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }

        public String getName() {
            return this.name;
        }

        public List<Credential> getCredentials() {
            return this.credentials;
        }

        public Set<String> getGroups() {
            return this.groups;
        }
    }

    private static class LoadedState {
        private final Map<String, AccountEntry> accounts;
        private final String realmName;
        private final long loadTime;

        private LoadedState(Map<String, AccountEntry> accounts, String realmName, long loadTime) {
            this.accounts = accounts;
            this.realmName = realmName;
            this.loadTime = loadTime;
        }

        public Map<String, AccountEntry> getAccounts() {
            return this.accounts;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public long getLoadTime() {
            return this.loadTime;
        }
    }

    public static class Builder {
        private String defaultRealm = null;
        private boolean plainText;
        private String groupsAttribute = "groups";

        Builder() {
        }

        public Builder setGroupsAttribute(String groupsAttribute) {
            this.groupsAttribute = groupsAttribute;
            return this;
        }

        public Builder setDefaultRealm(String defaultRealm) {
            this.defaultRealm = defaultRealm;
            return this;
        }

        public Builder setPlainText(boolean plainText) {
            this.plainText = plainText;
            return this;
        }

        public EncryptedPropertiesSecurityRealm build() {
            return new EncryptedPropertiesSecurityRealm(this);
        }
    }
}

