/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;

public class SSLEngineConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String[]> ENABLED_PROTOCOLS = AttributeDefinition.builder((String)"enabledProtocols", null, String[].class).build();
    static final AttributeDefinition<String> ENABLED_CIPHERSUITES = AttributeDefinition.builder((String)"enabledCiphersuites", null, String.class).build();
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ENGINE.toString());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SSLEngineConfiguration.class, new AttributeDefinition[]{ENABLED_PROTOCOLS, ENABLED_CIPHERSUITES});
    }

    SSLEngineConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public String[] enabledProtocols() {
        return (String[])this.attributes.attribute(ENABLED_PROTOCOLS).get();
    }

    public String enabledCiphersuites() {
        return (String)this.attributes.attribute(ENABLED_CIPHERSUITES).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSLEngineConfiguration that = (SSLEngineConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "SslEngineConfiguration{attributes=" + this.attributes + '}';
    }
}

