/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreRealmConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.ssl.SSLContextBuilder;

public class TrustStoreRealmConfigurationBuilder
implements Builder<TrustStoreRealmConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder securityRealmBuilder;
    private TrustManagerFactory trustManagerFactory;

    TrustStoreRealmConfigurationBuilder(RealmConfigurationBuilder securityRealmBuilder) {
        this.securityRealmBuilder = securityRealmBuilder;
        this.attributes = TrustStoreRealmConfiguration.attributeDefinitionSet();
    }

    public TrustStoreRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(TrustStoreRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    public void validate() {
    }

    public TrustStoreRealmConfigurationBuilder build() {
        if (this.trustManagerFactory == null) {
            SSLContextBuilder sslContextBuilder = this.securityRealmBuilder.sslContextBuilder();
            if (sslContextBuilder == null) {
                throw Server.log.trustStoreWithoutServerIdentity();
            }
            String name = (String)this.attributes.attribute(TrustStoreRealmConfiguration.NAME).get();
            try {
                KeyStore keyStore = this.securityRealmBuilder.serverIdentitiesConfiguration().sslConfiguration().trustStore().trustStore();
                this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.trustManagerFactory.init(keyStore);
                for (TrustManager trustManager : this.trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    this.securityRealmBuilder.addRealm(name, (SecurityRealm)new KeyStoreBackedSecurityRealm(keyStore));
                    this.securityRealmBuilder.addFeature(ServerSecurityRealm.Feature.TRUST);
                    break;
                }
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
        return this;
    }

    public TrustStoreRealmConfiguration create() {
        return new TrustStoreRealmConfiguration(this.attributes.protect());
    }

    public TrustStoreRealmConfigurationBuilder read(TrustStoreRealmConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

