/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.realm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.function.Consumer;
import org.infinispan.server.Server;
import org.infinispan.server.security.realm.EncryptedPropertiesSecurityRealm;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class PropertiesSecurityRealm
implements CacheableSecurityRealm {
    private final File usersFile;
    private final File groupsFile;
    private final boolean plainText;
    private final String groupsAttribute;
    private final String realmName;
    EncryptedPropertiesSecurityRealm delegate;

    public PropertiesSecurityRealm(File usersFile, File groupsFile, boolean plainText, String groupsAttribute, String realmName) {
        this.usersFile = usersFile;
        this.groupsFile = groupsFile;
        this.plainText = plainText;
        this.groupsAttribute = groupsAttribute;
        this.realmName = realmName;
        this.load();
    }

    private void load() {
        try (FileInputStream usersInputStream = new FileInputStream(this.usersFile);
             FileInputStream groupsInputStream = this.groupsFile != null ? new FileInputStream(this.groupsFile) : null;){
            this.delegate = EncryptedPropertiesSecurityRealm.builder().setUsersStream(usersInputStream).setGroupsStream(groupsInputStream).setPlainText(this.plainText).setGroupsAttribute(this.groupsAttribute).setDefaultRealm(this.realmName).build();
        }
        catch (IOException e) {
            throw Server.log.unableToLoadRealmPropertyFiles(e);
        }
    }

    void reload() {
        long loadTime = this.delegate.getLoadTime();
        if (this.usersFile.lastModified() > loadTime || this.groupsFile.lastModified() > loadTime) {
            try (FileInputStream usersInputStream = new FileInputStream(this.usersFile);
                 FileInputStream groupsInputStream = this.groupsFile != null ? new FileInputStream(this.groupsFile) : null;){
                this.delegate.load(usersInputStream, groupsInputStream);
            }
            catch (IOException e) {
                throw Server.log.unableToLoadRealmPropertyFiles(e);
            }
        }
    }

    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        this.reload();
        return this.delegate.getRealmIdentity(principal);
    }

    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        this.reload();
        return this.delegate.getRealmIdentity(evidence);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public boolean isEmpty() {
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(this.usersFile);){
            p.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p.isEmpty();
    }

    public void registerIdentityChangeListener(Consumer<Principal> listener) {
        this.delegate.registerIdentityChangeListener(listener);
    }
}

