/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging;

import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.OS;
import org.infinispan.server.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String serverStarting = "ISPN080000: %s Server starting";
    private static final String serverStarted = "ISPN080001: %s Server %s started in %dms";
    private static final String serverStopping = "ISPN080002: %s Server stopping";
    private static final String serverStopped = "ISPN080003: %s Server stopped";
    private static final String protocolStarted4 = "ISPN080004: Connector %s (%s) listening on %s:%d";
    private static final String cannotInstantiateProtocolServerConfigurationBuilder = "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    private static final String unknownInterface = "ISPN080009: Unknown interface '%s'";
    private static final String unknownSocketBinding = "ISPN080010: Unknown socket binding '%s'";
    private static final String unknownSecurityDomain = "ISPN080014: Unknown security domain '%s'";
    private static final String unableToLoadRealmPropertyFiles = "ISPN080015: Unable to load realm property files";
    private static final String noDefaultKeyManager = "ISPN080016: No default key manager available";
    private static final String serverConfiguration = "ISPN080017: Server configuration: %s";
    private static final String protocolStarted1 = "ISPN080018: Started connector %s (internal)";
    private static final String trustStoreWithoutServerIdentity = "ISPN080020: Cannot use a trust store without a server identity";
    private static final String authenticationWithoutSecurityRealm = "ISPN080021: Authentication cannot be configured without a security realm";
    private static final String cannotConfigureProtocolEncryptionUnderSinglePort = "ISPN080022: Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.";
    private static final String protocolCannotUseSameSocketBindingAsEndpoint = "ISPN080023: Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.";
    private static final String invalidUrl = "ISPN080024: Invalid URL";
    private static final String multipleEndpointsSameTypeFound = "ISPN080025: Cannot have multiple connectors of the same type: found [%s]";
    private static final String unnamedFactoryClass = "ISPN080026: Extension factory '%s' is lacking a @NamedFactory annotation";
    private static final String loadedExtension = "ISPN080027: Loaded extension '%s'";
    private static final String serverFailedToStart = "ISPN080028: %s Server failed to start";
    private static final String clusterShutdown = "ISPN080029: Cluster shutdown";
    private static final String clusteredTaskError = "ISPN080030: Clustered task error";
    private static final String unknownServerIdentity = "ISPN080031: Unknown server identity '%s'";
    private static final String loggingConfiguration = "ISPN080032: Logging configuration: %s";
    private static final String invalidNetworkConfiguration = "ISPN080033: Cannot find a network address which matches the supplied configuration";
    private static final String endpointUrl = "ISPN080034: Server '%s' listening on %s://%s:%d";
    private static final String unknownAppender = "ISPN080035: Unknown appender `%s`";
    private static final String invalidLevel = "ISPN080036: Invalid level `%s`";
    private static final String nameAlreadyBound = "ISPN080037: The name '%s' is already bound";
    private static final String dataSourceCreated = "ISPN080038: Created datasource '%s' bound to JNDI '%s'";
    private static final String invalidUnicodeSequence = "ISPN080039: Invalid Unicode sequence '%s'";
    private static final String noRealmFoundInProperties = "ISPN080040: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    private static final String duplicateDataSource = "ISPN080041: Duplicate data source '%s'";
    private static final String duplicateJndiName = "ISPN080042: Duplicate JNDI name '%s'";
    private static final String serverReportUnavailable = "ISPN080043: Cannot generate the server report on %s";
    private static final String warnHotRodLazyRetrievalDeprecated = "ISPN080044: HotRod lazy-retrieval has been deprecated and will be removed in a future version with no direct replacement";
    private static final String endpointSocketBindingConflict = "ISPN080045: Cannot have multiple endpoints bound to the same socket binding '%s'";
    private static final String unknownCredentialStore = "ISPN080046: Unknown credential store '%s'";
    private static final String unknownCredential = "ISPN080047: Unknown credential '%s' in store '%s'";
    private static final String missingCredentialStoreName = "ISPN080048: A credential store name is missing";
    private static final String unspecifiedCredentialAlias = "ISPN080049: A credential alias must be specified if the store doesn't contain a single alias";
    private static final String cannotOverrideCredential = "ISPN080050: Credential reference in element '%s' would override value specified in attribute '%s'";
    private static final String missingCredential = "ISPN080051: Element '%s' is missing a credential attribute '%s' or a credential reference";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serverStarting(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)name);
    }

    protected String serverStarting$str() {
        return serverStarting;
    }

    @Override
    public final void serverStarted(String name, String version, long ms) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarted$str(), (Object)name, (Object)version, (Object)ms);
    }

    protected String serverStarted$str() {
        return serverStarted;
    }

    @Override
    public final void serverStopping(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopping$str(), (Object)name);
    }

    protected String serverStopping$str() {
        return serverStopping;
    }

    @Override
    public final void serverStopped(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopped$str(), (Object)name);
    }

    protected String serverStopped$str() {
        return serverStopped;
    }

    @Override
    public final void protocolStarted(String name, String socketBinding, String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted4$str(), new Object[]{name, socketBinding, host, port});
    }

    protected String protocolStarted4$str() {
        return protocolStarted4;
    }

    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return cannotInstantiateProtocolServerConfigurationBuilder;
    }

    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(Class<?> klass, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownInterface$str() {
        return unknownInterface;
    }

    @Override
    public final CacheConfigurationException unknownInterface(String interfaceName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownInterface$str(), interfaceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSocketBinding$str() {
        return unknownSocketBinding;
    }

    @Override
    public final CacheConfigurationException unknownSocketBinding(String value) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSocketBinding$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSecurityDomain$str() {
        return unknownSecurityDomain;
    }

    @Override
    public final CacheConfigurationException unknownSecurityDomain(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSecurityDomain$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadRealmPropertyFiles$str() {
        return unableToLoadRealmPropertyFiles;
    }

    @Override
    public final CacheConfigurationException unableToLoadRealmPropertyFiles(IOException e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToLoadRealmPropertyFiles$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDefaultKeyManager$str() {
        return noDefaultKeyManager;
    }

    @Override
    public final NoSuchAlgorithmException noDefaultKeyManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultKeyManager$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void serverConfiguration(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverConfiguration$str(), (Object)name);
    }

    protected String serverConfiguration$str() {
        return serverConfiguration;
    }

    @Override
    public final void protocolStarted(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted1$str(), (Object)name);
    }

    protected String protocolStarted1$str() {
        return protocolStarted1;
    }

    protected String trustStoreWithoutServerIdentity$str() {
        return trustStoreWithoutServerIdentity;
    }

    @Override
    public final CacheConfigurationException trustStoreWithoutServerIdentity() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.trustStoreWithoutServerIdentity$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authenticationWithoutSecurityRealm$str() {
        return authenticationWithoutSecurityRealm;
    }

    @Override
    public final CacheConfigurationException authenticationWithoutSecurityRealm() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutSecurityRealm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConfigureProtocolEncryptionUnderSinglePort$str() {
        return cannotConfigureProtocolEncryptionUnderSinglePort;
    }

    @Override
    public final CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotConfigureProtocolEncryptionUnderSinglePort$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String protocolCannotUseSameSocketBindingAsEndpoint$str() {
        return protocolCannotUseSameSocketBindingAsEndpoint;
    }

    @Override
    public final CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.protocolCannotUseSameSocketBindingAsEndpoint$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidUrl$str() {
        return invalidUrl;
    }

    @Override
    public final CacheConfigurationException invalidUrl() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidUrl$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleEndpointsSameTypeFound$str() {
        return multipleEndpointsSameTypeFound;
    }

    @Override
    public final CacheConfigurationException multipleEndpointsSameTypeFound(String names) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.multipleEndpointsSameTypeFound$str(), names));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unnamedFactoryClass(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unnamedFactoryClass$str(), (Object)name);
    }

    protected String unnamedFactoryClass$str() {
        return unnamedFactoryClass;
    }

    @Override
    public final void loadedExtension(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loadedExtension$str(), (Object)name);
    }

    protected String loadedExtension$str() {
        return loadedExtension;
    }

    @Override
    public final void serverFailedToStart(String name, Exception e) {
        this.log.logf(FQCN, Logger.Level.FATAL, (Throwable)e, this.serverFailedToStart$str(), (Object)name);
    }

    protected String serverFailedToStart$str() {
        return serverFailedToStart;
    }

    @Override
    public final void clusterShutdown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.clusterShutdown$str(), new Object[0]);
    }

    protected String clusterShutdown$str() {
        return clusterShutdown;
    }

    @Override
    public final void clusteredTaskError(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.clusteredTaskError$str(), new Object[0]);
    }

    protected String clusteredTaskError$str() {
        return clusteredTaskError;
    }

    protected String unknownServerIdentity$str() {
        return unknownServerIdentity;
    }

    @Override
    public final IllegalArgumentException unknownServerIdentity(String serverPrincipal) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownServerIdentity$str(), serverPrincipal));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void loggingConfiguration(String absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loggingConfiguration$str(), (Object)absolutePath);
    }

    protected String loggingConfiguration$str() {
        return loggingConfiguration;
    }

    protected String invalidNetworkConfiguration$str() {
        return invalidNetworkConfiguration;
    }

    @Override
    public final CacheConfigurationException invalidNetworkConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidNetworkConfiguration$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void endpointUrl(Object name, String proto, String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointUrl$str(), new Object[]{name, proto, host, port});
    }

    protected String endpointUrl$str() {
        return endpointUrl;
    }

    protected String unknownAppender$str() {
        return unknownAppender;
    }

    @Override
    public final IllegalArgumentException unknownAppender(String appender) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownAppender$str(), appender));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLevel$str() {
        return invalidLevel;
    }

    @Override
    public final IllegalArgumentException invalidLevel(String level) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidLevel$str(), level));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameAlreadyBound$str() {
        return nameAlreadyBound;
    }

    @Override
    public final NamingException nameAlreadyBound(String name) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.nameAlreadyBound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void dataSourceCreated(String name, String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.dataSourceCreated$str(), (Object)name, (Object)jndiName);
    }

    protected String dataSourceCreated$str() {
        return dataSourceCreated;
    }

    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }

    @Override
    public final IOException invalidUnicodeSequence(String sequence, NoSuchElementException e) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidUnicodeSequence$str(), sequence), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noRealmFoundInProperties$str() {
        return noRealmFoundInProperties;
    }

    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.noRealmFoundInProperties$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateDataSource$str() {
        return duplicateDataSource;
    }

    @Override
    public final CacheConfigurationException duplicateDataSource(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateDataSource$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateJndiName$str() {
        return duplicateJndiName;
    }

    @Override
    public final CacheConfigurationException duplicateJndiName(String jndiName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateJndiName$str(), jndiName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverReportUnavailable$str() {
        return serverReportUnavailable;
    }

    @Override
    public final IllegalStateException serverReportUnavailable(OS os) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverReportUnavailable$str(), os));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void warnHotRodLazyRetrievalDeprecated() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnHotRodLazyRetrievalDeprecated$str(), new Object[0]);
    }

    protected String warnHotRodLazyRetrievalDeprecated$str() {
        return warnHotRodLazyRetrievalDeprecated;
    }

    protected String endpointSocketBindingConflict$str() {
        return endpointSocketBindingConflict;
    }

    @Override
    public final CacheConfigurationException endpointSocketBindingConflict(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.endpointSocketBindingConflict$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownCredentialStore$str() {
        return unknownCredentialStore;
    }

    @Override
    public final IllegalArgumentException unknownCredentialStore(String store) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownCredentialStore$str(), store));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownCredential$str() {
        return unknownCredential;
    }

    @Override
    public final IllegalArgumentException unknownCredential(String alias, String store) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownCredential$str(), alias, store));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCredentialStoreName$str() {
        return missingCredentialStoreName;
    }

    @Override
    public final IllegalArgumentException missingCredentialStoreName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingCredentialStoreName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unspecifiedCredentialAlias$str() {
        return unspecifiedCredentialAlias;
    }

    @Override
    public final CacheConfigurationException unspecifiedCredentialAlias() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unspecifiedCredentialAlias$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotOverrideCredential$str() {
        return cannotOverrideCredential;
    }

    @Override
    public final CacheConfigurationException cannotOverrideCredential(String element, String attribute) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotOverrideCredential$str(), element, attribute));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCredential$str() {
        return missingCredential;
    }

    @Override
    public final CacheConfigurationException missingCredential(String element, String attribute) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingCredential$str(), element, attribute));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

