/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.infinispan.server.configuration.security.SSLConfigurationBuilder;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;

public class ServerIdentitiesConfigurationBuilder
implements Builder<ServerIdentitiesConfiguration> {
    private final List<SSLConfigurationBuilder> sslConfigurations = new ArrayList<SSLConfigurationBuilder>();
    private final List<KerberosSecurityFactoryConfigurationBuilder> kerberosConfigurations = new ArrayList<KerberosSecurityFactoryConfigurationBuilder>();
    private final RealmConfigurationBuilder realmBuilder;

    ServerIdentitiesConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
    }

    public void validate() {
    }

    public SSLConfigurationBuilder addSslConfiguration() {
        SSLConfigurationBuilder ssl = new SSLConfigurationBuilder(this.realmBuilder);
        this.sslConfigurations.add(ssl);
        return ssl;
    }

    public KerberosSecurityFactoryConfigurationBuilder addKerberosConfiguration() {
        KerberosSecurityFactoryConfigurationBuilder kerberos = new KerberosSecurityFactoryConfigurationBuilder(this.realmBuilder);
        this.kerberosConfigurations.add(kerberos);
        return kerberos;
    }

    public ServerIdentitiesConfiguration create() {
        List<SSLConfiguration> sslConfigurations = this.sslConfigurations.stream().map(SSLConfigurationBuilder::create).collect(Collectors.toList());
        List<KerberosSecurityFactoryConfiguration> kerberosConfigurations = this.kerberosConfigurations.stream().map(KerberosSecurityFactoryConfigurationBuilder::create).collect(Collectors.toList());
        return new ServerIdentitiesConfiguration(sslConfigurations, kerberosConfigurations);
    }

    public ServerIdentitiesConfigurationBuilder read(ServerIdentitiesConfiguration template) {
        this.sslConfigurations.clear();
        template.sslConfigurations().forEach(s -> this.addSslConfiguration().read((SSLConfiguration)s));
        this.kerberosConfigurations.clear();
        template.kerberosConfigurations().forEach(s -> this.addKerberosConfiguration().read((KerberosSecurityFactoryConfiguration)s));
        return this;
    }
}

