/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.infinispan.commons.jdkspecific.ProcessInfo;
import org.infinispan.commons.util.Version;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.Server;
import org.infinispan.server.ShutdownHook;
import org.infinispan.server.logging.Messages;
import org.infinispan.server.tool.Main;

public class Bootstrap
extends Main {
    private final ExitHandler exitHandler;
    private Path configurationFile;
    private Path loggingFile;

    public Bootstrap(PrintStream stdOut, PrintStream stdErr, ExitHandler exitHandler, Properties properties) {
        super(stdOut, stdErr, properties);
        this.exitHandler = exitHandler;
    }

    public static void main(String[] args) {
        Bootstrap bootstrap = new Bootstrap(System.out, System.err, new DefaultExitHandler(), System.getProperties());
        bootstrap.run(args);
    }

    @Override
    protected void handleArgumentCommand(String command, String parameter, Iterator<String> args) {
        switch (command) {
            case "-c": {
                parameter = args.next();
            }
            case "--server-config": {
                this.configurationFile = Paths.get(parameter, new String[0]);
                break;
            }
            case "-l": {
                parameter = args.next();
            }
            case "--logging-config": {
                this.loggingFile = Paths.get(parameter, new String[0]);
                break;
            }
            case "-s": {
                parameter = args.next();
            }
            case "--server-root": {
                this.serverRoot = new File(parameter);
                break;
            }
            case "-b": {
                parameter = args.next();
            }
            case "--bind-address": {
                this.properties.setProperty("infinispan.bind.address", parameter);
                break;
            }
            case "-p": {
                parameter = args.next();
            }
            case "--bind-port": {
                this.properties.setProperty("infinispan.bind.port", parameter);
                break;
            }
            case "-n": {
                parameter = args.next();
            }
            case "--node-name": {
                this.properties.setProperty("infinispan.node.name", parameter);
                break;
            }
            case "-g": {
                parameter = args.next();
            }
            case "--cluster-name": {
                this.properties.setProperty("infinispan.cluster.name", parameter);
                break;
            }
            case "-j": {
                parameter = args.next();
            }
            case "--cluster-stack": {
                this.properties.setProperty("infinispan.cluster.stack", parameter);
                break;
            }
            case "-k": {
                parameter = args.next();
            }
            case "--cluster-address": {
                this.properties.setProperty("jgroups.bind.address", parameter);
                break;
            }
            case "-o": {
                parameter = args.next();
            }
            case "--port-offset": {
                this.properties.setProperty("infinispan.socket.binding.port-offset", parameter);
                int offset = Integer.parseInt(parameter);
                if (this.properties.containsKey("jgroups.bind.port")) break;
                this.properties.setProperty("jgroups.bind.port", Integer.toString(7800 + offset));
                break;
            }
            case "-P": {
                parameter = args.next();
            }
            case "--properties": {
                try (BufferedReader r = Files.newBufferedReader(Paths.get(parameter, new String[0]));){
                    Properties loaded = new Properties();
                    loaded.load(r);
                    loaded.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.properties::putIfAbsent));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            default: {
                throw new IllegalArgumentException(command);
            }
        }
    }

    @Override
    public void runInternal() {
        if (!this.serverRoot.isAbsolute()) {
            this.serverRoot = this.serverRoot.getAbsoluteFile();
        }
        this.properties.putIfAbsent("infinispan.server.config.path", new File(this.serverRoot, "conf").getAbsolutePath());
        Path confDir = Paths.get(this.properties.getProperty("infinispan.server.config.path"), new String[0]);
        if (this.configurationFile == null) {
            this.configurationFile = Paths.get("infinispan.xml", new String[0]);
        }
        File logDir = new File(this.serverRoot, "log");
        this.properties.putIfAbsent("infinispan.server.log.path", logDir.getAbsolutePath());
        if (this.loggingFile == null) {
            this.loggingFile = confDir.resolve("log4j2.xml");
        } else if (!this.loggingFile.isAbsolute()) {
            this.loggingFile = confDir.resolve(this.loggingFile);
        }
        if (!Files.isReadable(this.loggingFile)) {
            this.stdErr.printf("Cannot read %s", this.loggingFile);
            return;
        }
        System.setProperty("log4j.configurationFile", this.loggingFile.toAbsolutePath().toString());
        this.logJVMInformation();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this.exitHandler));
        Server.log.serverStarting(Version.getBrandName());
        Server.log.serverConfiguration(this.configurationFile.toString());
        Server.log.loggingConfiguration(this.loggingFile.toString());
        try (Server server = new Server(this.serverRoot, this.configurationFile.toFile(), this.properties);){
            server.setExitHandler(this.exitHandler);
            server.run().get();
        }
        catch (Exception e) {
            Server.log.serverFailedToStart(Version.getBrandName(), e);
        }
    }

    @Override
    public void help(PrintStream out) {
        out.printf("Usage:%n", new Object[0]);
        out.printf("  -b, --bind-address=<address>  %s%n", Messages.MSG.serverHelpBindAddress());
        out.printf("  -c, --server-config=<config>  %s%n", Messages.MSG.serverHelpServerConfig("infinispan.xml"));
        out.printf("  -l, --logging-config=<config> %s%n", Messages.MSG.serverHelpLoggingConfig("log4j2.xml"));
        out.printf("  -g, --cluster-name=<name>     %s%n", Messages.MSG.serverHelpClusterName());
        out.printf("  -h, --help                    %s%n", Messages.MSG.toolHelpHelp());
        out.printf("  -j, --cluster-stack=<name>    %s%n", Messages.MSG.serverHelpClusterStack());
        out.printf("  -k, --cluster-address=<name>  %s%n", Messages.MSG.serverHelpClusterAddress());
        out.printf("  -n, --node-name=<name>        %s%n", Messages.MSG.serverHelpNodeName());
        out.printf("  -o, --port-offset=<offset>    %s%n", Messages.MSG.serverHelpPortOffset());
        out.printf("  -p, --bind-port=<port>        %s%n", Messages.MSG.serverHelpBindPort(11222));
        out.printf("  -s, --server-root=<path>      %s%n", Messages.MSG.toolHelpServerRoot("server"));
        out.printf("  -v, --version                 %s%n", Messages.MSG.toolHelpVersion());
        out.printf("  -D<name>=<value>              %s%n", Messages.MSG.serverHelpProperty());
        out.printf("  -P, --properties=<file>       %s%n", Messages.MSG.serverHelpProperties());
    }

    @Override
    public void version(PrintStream out) {
        out.printf("%s Server %s (%s)\n", Version.getBrandName(), Version.getVersion(), Version.getCodename());
        out.println("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors");
        out.println("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0");
    }

    private void logJVMInformation() {
        Logger logger2 = Logger.getLogger("BOOT");
        logger2.info("JVM " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version"));
        ProcessInfo process = ProcessInfo.getInstance();
        logger2.info("JVM arguments = " + process.getArguments());
        logger2.info("PID = " + process.getPid());
        if (logger2.isLoggable(Level.FINE)) {
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            for (URL url : cl.getURLs()) {
                logger2.fine("JAR: " + url);
            }
        }
    }

    static {
        System.setProperty("log4j2.contextSelector", "org.apache.logging.log4j.core.selector.BasicContextSelector");
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
    }
}

