/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfiguration;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class LdapRealmConfigurationBuilder
implements Builder<LdapRealmConfiguration> {
    private final AttributeSet attributes;
    private final List<LdapIdentityMappingConfigurationBuilder> identityMappings = new ArrayList<LdapIdentityMappingConfigurationBuilder>();
    private final RealmConfigurationBuilder realmBuilder;
    private SecurityRealm securityRealm;
    private final SimpleDirContextFactoryBuilder dirContextBuilder = SimpleDirContextFactoryBuilder.builder();
    private final LdapSecurityRealmBuilder ldapRealmBuilder = LdapSecurityRealmBuilder.builder();
    private final LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder = this.ldapRealmBuilder.identityMapping();

    LdapRealmConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = LdapRealmConfiguration.attributeDefinitionSet();
    }

    public SimpleDirContextFactoryBuilder getDirContextBuilder() {
        return this.dirContextBuilder;
    }

    LdapSecurityRealmBuilder getLdapRealmBuilder() {
        return this.ldapRealmBuilder;
    }

    LdapSecurityRealmBuilder.IdentityMappingBuilder getIdentityMappingBuilder() {
        return this.identityMappingBuilder;
    }

    public LdapIdentityMappingConfigurationBuilder addIdentityMap() {
        LdapIdentityMappingConfigurationBuilder identity = new LdapIdentityMappingConfigurationBuilder(this);
        this.identityMappings.add(identity);
        return identity;
    }

    public LdapRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(LdapRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    public LdapRealmConfigurationBuilder url(String url) {
        this.attributes.attribute(LdapRealmConfiguration.URL).set((Object)url);
        this.dirContextBuilder.setProviderUrl(url);
        return this;
    }

    public LdapRealmConfigurationBuilder principal(String principal) {
        this.attributes.attribute(LdapRealmConfiguration.PRINCIPAL).set((Object)principal);
        this.dirContextBuilder.setSecurityPrincipal(principal);
        return this;
    }

    public LdapRealmConfigurationBuilder credential(String credential) {
        this.attributes.attribute(LdapRealmConfiguration.CREDENTIAL).set((Object)credential);
        this.dirContextBuilder.setSecurityCredential(credential);
        return this;
    }

    public LdapRealmConfigurationBuilder directEvidenceVerification(boolean value) {
        this.attributes.attribute(LdapRealmConfiguration.DIRECT_EVIDENCE_VERIFICATION).set((Object)value);
        this.ldapRealmBuilder.addDirectEvidenceVerification(value);
        return this;
    }

    public LdapRealmConfigurationBuilder pageSize(int value) {
        this.attributes.attribute(LdapRealmConfiguration.PAGE_SIZE).set((Object)value);
        this.ldapRealmBuilder.setPageSize(value);
        return this;
    }

    public LdapRealmConfigurationBuilder searchDn(String value) {
        this.attributes.attribute(LdapRealmConfiguration.SEARCH_DN).set((Object)value);
        this.identityMappingBuilder.setSearchDn(value);
        return this;
    }

    public LdapRealmConfigurationBuilder rdnIdentifier(String value) {
        this.attributes.attribute(LdapRealmConfiguration.RDN_IDENTIFIER).set((Object)value);
        this.identityMappingBuilder.setRdnIdentifier(value);
        return this;
    }

    public LdapRealmConfigurationBuilder nameRewriter(NameRewriter rewriter) {
        this.attributes.attribute(LdapRealmConfiguration.NAME_REWRITER).set((Object)rewriter);
        return this;
    }

    public LdapRealmConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.attributes.attribute(LdapRealmConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    public LdapRealmConfigurationBuilder readTimeout(int readTimeout) {
        this.attributes.attribute(LdapRealmConfiguration.READ_TIMEOUT).set((Object)readTimeout);
        return this;
    }

    public LdapRealmConfigurationBuilder connectionPooling(boolean connectionPooling) {
        this.attributes.attribute(LdapRealmConfiguration.CONNECTION_POOLING).set((Object)connectionPooling);
        return this;
    }

    public LdapRealmConfigurationBuilder referralMode(DirContextFactory.ReferralMode referralMode) {
        this.attributes.attribute(LdapRealmConfiguration.REFERRAL_MODE).set((Object)referralMode);
        return this;
    }

    public void validate() {
        this.identityMappings.forEach(LdapIdentityMappingConfigurationBuilder::validate);
    }

    public LdapRealmConfiguration create() {
        List<LdapIdentityMappingConfiguration> identities = this.identityMappings.stream().map(LdapIdentityMappingConfigurationBuilder::create).collect(Collectors.toList());
        return new LdapRealmConfiguration(this.attributes.protect(), identities);
    }

    public LdapRealmConfigurationBuilder read(LdapRealmConfiguration template) {
        this.attributes.read(template.attributes());
        this.identityMappings.clear();
        template.identityMappings().forEach(i -> this.addIdentityMap().read((LdapIdentityMappingConfiguration)i));
        return this;
    }

    public SecurityRealm build() {
        if (this.securityRealm == null) {
            this.identityMappingBuilder.build();
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty("com.sun.jndi.ldap.connect.pool", ((Boolean)this.attributes.attribute(LdapRealmConfiguration.CONNECTION_POOLING).get()).toString());
            this.dirContextBuilder.setConnectTimeout(((Integer)this.attributes.attribute(LdapRealmConfiguration.CONNECTION_TIMEOUT).get()).intValue()).setReadTimeout(((Integer)this.attributes.attribute(LdapRealmConfiguration.READ_TIMEOUT).get()).intValue());
            this.dirContextBuilder.setConnectionProperties(connectionProperties);
            DirContextFactory dirContextFactory = this.dirContextBuilder.build();
            this.ldapRealmBuilder.setDirContextSupplier(() -> dirContextFactory.obtainDirContext((DirContextFactory.ReferralMode)this.attributes.attribute(LdapRealmConfiguration.REFERRAL_MODE).get()));
            if (this.attributes.attribute(LdapRealmConfiguration.NAME_REWRITER).isModified()) {
                this.ldapRealmBuilder.setNameRewriter((NameRewriter)this.attributes.attribute(LdapRealmConfiguration.NAME_REWRITER).get());
            }
            String name = (String)this.attributes.attribute(LdapRealmConfiguration.NAME).get();
            SecurityDomain.Builder domainBuilder = this.realmBuilder.domainBuilder();
            this.securityRealm = this.ldapRealmBuilder.build();
            domainBuilder.addRealm(name, this.securityRealm).build();
            if (domainBuilder.getDefaultRealmName() == null) {
                domainBuilder.setDefaultRealmName(name);
            }
        }
        return this.securityRealm;
    }
}

