/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging.events;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionContextQueryBuilder;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.server.logging.events.DecoratedServerEventLogger;
import org.infinispan.server.logging.events.SecurityActions;
import org.infinispan.server.logging.events.ServerEventImpl;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogger;

public class ServerEventLogger
implements EventLogger {
    public static final String EVENT_LOG_CACHE = "___event_log_cache";
    public static final Log log = LogFactory.getLog(ServerEventLogger.class);
    private final EmbeddedCacheManager cacheManager;
    private final TimeService timeService;
    private Cache<UUID, ServerEventImpl> eventCache;

    ServerEventLogger(EmbeddedCacheManager cacheManager, TimeService timeService) {
        this.cacheManager = cacheManager;
        this.timeService = timeService;
    }

    private Cache<UUID, ServerEventImpl> getEventCache() {
        if (this.eventCache == null) {
            this.eventCache = this.cacheManager.getCache(EVENT_LOG_CACHE);
        }
        return this.eventCache;
    }

    public void log(EventLogLevel level, EventLogCategory category, String message) {
        this.textLog(level, category, message);
        this.eventLog(new ServerEventImpl(this.timeService.instant(), level, category, message));
    }

    void textLog(EventLogLevel level, EventLogCategory category, String message) {
        LogFactory.getLogger((String)category.toString()).log(level.toLoggerLevel(), (Object)message);
    }

    void eventLog(ServerEventImpl event) {
        this.getEventCache().putAsync((Object)Util.threadLocalRandomUUID(), (Object)event);
    }

    public EventLogger scope(String scope) {
        return new DecoratedServerEventLogger(this).scope(scope);
    }

    public EventLogger context(String cacheName) {
        return new DecoratedServerEventLogger(this).context(cacheName);
    }

    public EventLogger detail(String detail) {
        return new DecoratedServerEventLogger(this).detail(detail);
    }

    public EventLogger who(String s) {
        return new DecoratedServerEventLogger(this).who(s);
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    public List<EventLog> getEvents(Instant start, int count, Optional<EventLogCategory> category, Optional<EventLogLevel> level) {
        List events = Collections.synchronizedList(new ArrayList());
        AtomicReference throwable = new AtomicReference();
        try {
            SecurityActions.getClusterExecutor(this.cacheManager).submitConsumer((SerializableFunction & Serializable)m -> {
                Cache cache = m.getCache(EVENT_LOG_CACHE);
                QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
                FilterConditionContextQueryBuilder filter = ((QueryBuilder)queryFactory.from(ServerEventImpl.class).orderBy("when", SortOrder.DESC).maxResults(count)).having("when").lte((Object)start);
                category.map(arg_0 -> ServerEventLogger.lambda$getEvents$0((FilterConditionContext)filter, queryFactory, arg_0));
                level.map(arg_0 -> ServerEventLogger.lambda$getEvents$1((FilterConditionContext)filter, queryFactory, arg_0));
                List nodeEvents = filter.toBuilder().build().list();
                return nodeEvents;
            }, (address, nodeEvents, t) -> {
                if (t == null) {
                    events.addAll(nodeEvents);
                } else {
                    throwable.set(t);
                }
            }).get(1L, TimeUnit.MINUTES);
            Throwable th = (Throwable)throwable.get();
            if (th != null) {
                throw new CacheException(th);
            }
        }
        catch (CacheException e) {
            log.debug((Object)"Could not retrieve events", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)"Could not retrieve events", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
        Collections.sort(events);
        return events.subList(0, Math.min(events.size(), count));
    }

    private static /* synthetic */ FilterConditionContextQueryBuilder lambda$getEvents$1(FilterConditionContext filter, QueryFactory queryFactory, EventLogLevel l) {
        return filter.and((FilterConditionContext)queryFactory.having("level").eq((Object)l));
    }

    private static /* synthetic */ FilterConditionContextQueryBuilder lambda$getEvents$0(FilterConditionContext filter, QueryFactory queryFactory, EventLogCategory c) {
        return filter.and((FilterConditionContext)queryFactory.having("category").eq((Object)c));
    }
}

