/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.jboss.logmanager.formatters.JsonFormatter;
import org.jboss.logmanager.formatters.StructuredFormatter;

public final class LightJsonFormatter
extends JsonFormatter {
    private static final Set<String> bannedKeys = new HashSet<String>();
    private final Map<String, Object> config = new HashMap<String, Object>();
    private JsonGeneratorFactory factory = Json.createGeneratorFactory(this.config);

    public LightJsonFormatter() {
    }

    public LightJsonFormatter(String keyOverrides) {
        super(keyOverrides);
    }

    public LightJsonFormatter(Map<StructuredFormatter.Key, String> keyOverrides) {
        super(keyOverrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrettyPrint() {
        Map<String, Object> map = this.config;
        synchronized (map) {
            return this.config.containsKey("javax.json.stream.JsonGenerator.prettyPrinting") ? (Boolean)this.config.get("javax.json.stream.JsonGenerator.prettyPrinting") : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrettyPrint(boolean prettyPrint) {
        Map<String, Object> map = this.config;
        synchronized (map) {
            if (prettyPrint) {
                this.config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            } else {
                this.config.remove("javax.json.stream.JsonGenerator.prettyPrinting");
            }
            this.factory = Json.createGeneratorFactory(this.config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StructuredFormatter.Generator createGenerator(Writer writer) {
        JsonGeneratorFactory factory;
        Map<String, Object> map = this.config;
        synchronized (map) {
            factory = this.factory;
        }
        return new LightJsonGenerator(factory.createGenerator(writer));
    }

    static {
        bannedKeys.add(StructuredFormatter.Key.LOGGER_CLASS_NAME.getKey());
        bannedKeys.add(StructuredFormatter.Key.MDC.getKey());
        bannedKeys.add(StructuredFormatter.Key.NDC.getKey());
    }

    private static final class LightJsonGenerator
    implements StructuredFormatter.Generator {
        private final JsonGenerator generator;

        private LightJsonGenerator(JsonGenerator generator) {
            this.generator = generator;
        }

        public StructuredFormatter.Generator begin() {
            this.generator.writeStartObject();
            return this;
        }

        public StructuredFormatter.Generator add(String key, int value) {
            if (!bannedKeys.contains(key)) {
                this.generator.write(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, long value) {
            if (!bannedKeys.contains(key)) {
                this.generator.write(key, value);
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, Map<String, ?> value) {
            if (!bannedKeys.contains(key)) {
                this.generator.writeStartObject(key);
                if (value != null) {
                    for (Map.Entry<String, ?> entry : value.entrySet()) {
                        this.writeObject(entry.getKey(), entry.getValue());
                    }
                }
                this.generator.writeEnd();
            }
            return this;
        }

        public StructuredFormatter.Generator add(String key, String value) {
            if (!bannedKeys.contains(key)) {
                if (value == null) {
                    this.generator.writeNull(key);
                } else {
                    this.generator.write(key, value);
                }
            }
            return this;
        }

        public StructuredFormatter.Generator startObject(String key) {
            if (key == null) {
                this.generator.writeStartObject();
            } else {
                this.generator.writeStartObject(key);
            }
            return this;
        }

        public StructuredFormatter.Generator endObject() {
            this.generator.writeEnd();
            return this;
        }

        public StructuredFormatter.Generator startArray(String key) {
            if (key == null) {
                this.generator.writeStartArray();
            } else {
                this.generator.writeStartArray(key);
            }
            return this;
        }

        public StructuredFormatter.Generator endArray() {
            this.generator.writeEnd();
            return this;
        }

        public StructuredFormatter.Generator end() {
            this.generator.writeEnd();
            this.generator.flush();
            this.generator.close();
            return this;
        }

        private void writeObject(String key, Object obj) {
            if (obj == null) {
                if (key == null) {
                    this.generator.writeNull();
                } else {
                    this.generator.writeNull(key);
                }
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                if (key == null) {
                    this.generator.write(value.booleanValue());
                } else {
                    this.generator.write(key, value.booleanValue());
                }
            } else if (obj instanceof Integer) {
                Integer value = (Integer)obj;
                if (key == null) {
                    this.generator.write(value.intValue());
                } else {
                    this.generator.write(key, value.intValue());
                }
            } else if (obj instanceof Long) {
                Long value = (Long)obj;
                if (key == null) {
                    this.generator.write(value.longValue());
                } else {
                    this.generator.write(key, value.longValue());
                }
            } else if (obj instanceof Double) {
                Double value = (Double)obj;
                if (key == null) {
                    this.generator.write(value.doubleValue());
                } else {
                    this.generator.write(key, value.doubleValue());
                }
            } else if (obj instanceof BigInteger) {
                BigInteger value = (BigInteger)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof String) {
                String value = (String)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else if (obj instanceof JsonValue) {
                JsonValue value = (JsonValue)obj;
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            } else {
                String value = String.valueOf(obj);
                if (key == null) {
                    this.generator.write(value);
                } else {
                    this.generator.write(key, value);
                }
            }
        }
    }
}

