/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.tasks.SecurityActions;
import org.infinispan.server.tasks.ServerTaskEngine;
import org.infinispan.server.tasks.ServerTaskWrapper;
import org.infinispan.tasks.TaskContext;

public class DistributedServerTask<T>
implements Serializable,
Function<EmbeddedCacheManager, T> {
    private final String cacheName;
    private final Optional<Map<String, ?>> parameters;
    private final String taskName;

    public DistributedServerTask(String cacheName, String taskName, Optional<Map<String, ?>> parameters) {
        this.cacheName = cacheName;
        this.taskName = taskName;
        this.parameters = parameters;
    }

    @Override
    public T apply(EmbeddedCacheManager embeddedCacheManager) {
        Cache cache = embeddedCacheManager.getCache(this.cacheName);
        GlobalComponentRegistry componentRegistry = SecurityActions.getGlobalComponentRegistry(embeddedCacheManager);
        ServerTaskEngine serverTaskEngine = (ServerTaskEngine)componentRegistry.getComponent(ServerTaskEngine.class);
        Marshaller marshaller = (Marshaller)componentRegistry.getComponent(StreamingMarshaller.class);
        ServerTaskWrapper task = serverTaskEngine.getTask(this.taskName);
        task.inject(this.prepareContext((Cache<Object, Object>)cache, marshaller));
        try {
            return task.run();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private TaskContext prepareContext(Cache<Object, Object> cache, Marshaller marshaller) {
        TaskContext context = new TaskContext();
        if (this.parameters.isPresent()) {
            context.parameters(this.parameters.get());
        }
        String type = "application/x-java-object";
        if (cache != null) {
            context.cache((Cache)cache.getAdvancedCache().withMediaType(type, type));
        }
        if (marshaller != null) {
            context.marshaller(marshaller);
        }
        return context;
    }
}

