/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.FileSystemRealmConfiguration;
import org.infinispan.server.configuration.security.KerberosRealmConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.LocalRealmConfiguration;
import org.infinispan.server.configuration.security.PropertiesRealmConfiguration;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.configuration.security.TrustStoreRealmConfiguration;

public class RealmConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SECURITY_REALM.toString());
    private final AttributeSet attributes;
    private final FileSystemRealmConfiguration fileSystemConfiguration;
    private final LdapRealmConfiguration ldapConfiguration;
    private final LocalRealmConfiguration localConfiguration;
    private final KerberosRealmConfiguration kerberosConfiguration;
    private final TokenRealmConfiguration tokenConfiguration;
    private final TrustStoreRealmConfiguration trustStoreConfiguration;
    private final ServerIdentitiesConfiguration serverIdentitiesConfiguration;
    private final PropertiesRealmConfiguration propertiesRealmConfiguration;
    private final List<ConfigurationInfo> elements;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RealmConfiguration.class, new AttributeDefinition[]{NAME});
    }

    RealmConfiguration(AttributeSet attributes, FileSystemRealmConfiguration fileSystemConfiguration, LdapRealmConfiguration ldapConfiguration, LocalRealmConfiguration localConfiguration, KerberosRealmConfiguration kerberosConfiguration, TokenRealmConfiguration tokenConfiguration, TrustStoreRealmConfiguration trustStoreConfiguration, ServerIdentitiesConfiguration serverIdentitiesConfiguration, PropertiesRealmConfiguration propertiesRealmConfiguration) {
        this.attributes = attributes.checkProtection();
        this.fileSystemConfiguration = fileSystemConfiguration;
        this.ldapConfiguration = ldapConfiguration;
        this.localConfiguration = localConfiguration;
        this.kerberosConfiguration = kerberosConfiguration;
        this.tokenConfiguration = tokenConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
        this.serverIdentitiesConfiguration = serverIdentitiesConfiguration;
        this.propertiesRealmConfiguration = propertiesRealmConfiguration;
        this.elements = Arrays.asList(fileSystemConfiguration, ldapConfiguration, localConfiguration, kerberosConfiguration, tokenConfiguration, trustStoreConfiguration, serverIdentitiesConfiguration, propertiesRealmConfiguration);
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    FileSystemRealmConfiguration fileSystemConfiguration() {
        return this.fileSystemConfiguration;
    }

    LdapRealmConfiguration ldapConfiguration() {
        return this.ldapConfiguration;
    }

    LocalRealmConfiguration localConfiguration() {
        return this.localConfiguration;
    }

    KerberosRealmConfiguration kerberosConfiguration() {
        return this.kerberosConfiguration;
    }

    TokenRealmConfiguration tokenConfiguration() {
        return this.tokenConfiguration;
    }

    TrustStoreRealmConfiguration trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    ServerIdentitiesConfiguration serverIdentitiesConfiguration() {
        return this.serverIdentitiesConfiguration;
    }

    PropertiesRealmConfiguration propertiesRealm() {
        return this.propertiesRealmConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmConfiguration that = (RealmConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "RealmConfiguration{attributes=" + this.attributes + ", fileSystemConfiguration=" + this.fileSystemConfiguration + ", ldapConfiguration=" + this.ldapConfiguration + ", localConfiguration=" + this.localConfiguration + ", kerberosConfiguration=" + this.kerberosConfiguration + ", tokenConfiguration=" + this.tokenConfiguration + ", trustStoreConfiguration=" + this.trustStoreConfiguration + ", serverIdentitiesConfiguration=" + this.serverIdentitiesConfiguration + ", propertiesRealmConfiguration=" + this.propertiesRealmConfiguration + '}';
    }
}

