/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.LdapAttributeConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;

public class LdapAttributeConfigurationBuilder
implements Builder<LdapAttributeConfiguration> {
    private final AttributeSet attributes;
    private final LdapRealmConfigurationBuilder ldapConfigurationBuilder;
    private AttributeMapping.Builder attributeMappingBuilder;

    LdapAttributeConfigurationBuilder(LdapRealmConfigurationBuilder ldapConfigurationBuilder) {
        this.ldapConfigurationBuilder = ldapConfigurationBuilder;
        this.attributes = LdapAttributeConfiguration.attributeDefinitionSet();
    }

    public LdapAttributeConfigurationBuilder filter(String filter) {
        this.attributes.attribute(LdapAttributeConfiguration.FILTER).set((Object)filter);
        this.attributeMappingBuilder = AttributeMapping.fromFilter((String)filter);
        return this;
    }

    public LdapAttributeConfigurationBuilder filterBaseDn(String filterBaseDn) {
        this.attributes.attribute(LdapAttributeConfiguration.FILTER_DN).set((Object)filterBaseDn);
        this.attributeMappingBuilder.searchDn(filterBaseDn);
        return this;
    }

    public LdapAttributeConfigurationBuilder from(String from) {
        this.attributes.attribute(LdapAttributeConfiguration.FROM).set((Object)from);
        this.attributeMappingBuilder.from(from);
        return this;
    }

    public LdapAttributeConfigurationBuilder to(String to) {
        this.attributes.attribute(LdapAttributeConfiguration.TO).set((Object)to);
        this.attributeMappingBuilder.to(to);
        return this;
    }

    public void build() {
        AttributeMapping attributeMapping = this.attributeMappingBuilder.build();
        this.ldapConfigurationBuilder.getIdentityMappingBuilder().map(new AttributeMapping[]{attributeMapping});
    }

    public void validate() {
    }

    public LdapAttributeConfiguration create() {
        return new LdapAttributeConfiguration(this.attributes.protect());
    }

    public LdapAttributeConfigurationBuilder read(LdapAttributeConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

