/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.configuration.security.FileSystemRealmConfiguration;
import org.infinispan.server.configuration.security.KerberosRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.security.realm.KerberosSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;

public class KerberosRealmConfigurationBuilder
implements Builder<KerberosRealmConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;
    private KerberosSecurityRealm securityRealm;

    KerberosRealmConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = KerberosRealmConfiguration.attributeDefinitionSet();
    }

    public KerberosRealmConfigurationBuilder path(String path) {
        this.attributes.attribute(KerberosRealmConfiguration.KEYTAB_PATH).set((Object)path);
        return this;
    }

    public KerberosRealmConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(KerberosRealmConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public void validate() {
    }

    public KerberosRealmConfiguration create() {
        return new KerberosRealmConfiguration(this.attributes.protect(), this.securityRealm);
    }

    public KerberosRealmConfigurationBuilder read(KerberosRealmConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public KerberosSecurityRealm build() {
        if (this.securityRealm == null) {
            String path = (String)this.attributes.attribute(KerberosRealmConfiguration.KEYTAB_PATH).get();
            String relativeTo = (String)this.attributes.attribute(FileSystemRealmConfiguration.RELATIVE_TO).get();
            File keyTab = new File(ParseUtils.resolvePath((String)path, (String)relativeTo));
            this.securityRealm = new KerberosSecurityRealm(keyTab);
            this.realmBuilder.domainBuilder().addRealm("kerberos", (SecurityRealm)this.securityRealm).build();
        }
        return this.securityRealm;
    }
}

