/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;

public class KeycloakRoleDecoder
implements RoleDecoder {
    private static final String CLAIM_REALM_ACCESS = "realm_access";
    private static final String CLAIM_RESOURCE_ACCESS = "resource_access";
    private static final String CLAIM_ROLES = "roles";
    private static final ObjectMapper mapper = new ObjectMapper();

    public Roles decodeRoles(AuthorizationIdentity identity) {
        Attributes.Entry resourceAccess;
        Attributes attributes = identity.getAttributes();
        Attributes.Entry realmAccess = attributes.get(CLAIM_REALM_ACCESS);
        HashSet roleSet = new HashSet();
        if (realmAccess != null) {
            String realmAccessValue = (String)realmAccess.get(0);
            try {
                Map jsonNode = (Map)mapper.readValue(realmAccessValue, Map.class);
                List roles = (List)jsonNode.get(CLAIM_ROLES);
                if (roles != null) {
                    roleSet.addAll(roles);
                }
            }
            catch (IOException cause) {
                throw new RuntimeException("Failed to decode realm access roles", cause);
            }
        }
        if ((resourceAccess = attributes.get(CLAIM_RESOURCE_ACCESS)) != null) {
            for (String resource : resourceAccess) {
                try {
                    Map resources = (Map)mapper.readValue(resource, Map.class);
                    for (String resourceKey : resources.keySet()) {
                        List roles = (List)((Map)resources.get(resourceKey)).get(CLAIM_ROLES);
                        if (roles == null) continue;
                        roleSet.addAll(roles);
                    }
                }
                catch (IOException cause) {
                    throw new RuntimeException("Failed to decode resource access roles", cause);
                }
            }
        }
        return Roles.fromSet(roleSet);
    }
}

