/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.InterfacesConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.configuration.security.SecurityConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.security.ServerSecurityRealm;

public class ServerConfigurationBuilder
implements Builder<ServerConfiguration> {
    private final List<ProtocolServerConfigurationBuilder<?, ?>> connectors = new ArrayList(2);
    private final GlobalConfigurationBuilder builder;
    private final SinglePortServerConfigurationBuilder endpoint = new SinglePortServerConfigurationBuilder();
    private final InterfacesConfigurationBuilder interfaces = new InterfacesConfigurationBuilder();
    private final SocketBindingsConfigurationBuilder socketBindings = new SocketBindingsConfigurationBuilder(this);
    private final SecurityConfigurationBuilder security = new SecurityConfigurationBuilder();

    public ServerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public <T extends ProtocolServerConfigurationBuilder<?, ?>> T addConnector(Class<T> klass) {
        try {
            ProtocolServerConfigurationBuilder builder = (ProtocolServerConfigurationBuilder)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.connectors.add(builder);
            this.endpoint.applyConfigurationToProtocol(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw Server.log.cannotInstantiateProtocolServerConfigurationBuilder(klass, e);
        }
    }

    public List<ProtocolServerConfigurationBuilder<?, ?>> connectors() {
        return this.connectors;
    }

    public SinglePortServerConfigurationBuilder endpoint() {
        return this.endpoint;
    }

    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    public InterfacesConfigurationBuilder interfaces() {
        return this.interfaces;
    }

    public SocketBindingsConfigurationBuilder socketBindings() {
        return this.socketBindings;
    }

    public void validate() {
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.interfaces.create(), this.socketBindings.create(), this.security.create(), this.connectors.stream().map(b -> (ProtocolServerConfiguration)b.create()).collect(Collectors.toList()), this.endpoint.create());
    }

    public Builder<?> read(ServerConfiguration template) {
        return this;
    }

    public ServerSecurityRealm getSecurityRealm(String name) {
        ServerSecurityRealm serverSecurityRealm = this.security.realms().getServerSecurityRealm(name);
        if (serverSecurityRealm == null) {
            throw Server.log.unknownSecurityDomain(name);
        }
        return serverSecurityRealm;
    }

    public boolean hasSSLContext(String name) {
        return this.security.realms().getSSLContext(name) != null;
    }

    public SSLContext getSSLContext(String name) {
        SSLContext sslContext = this.security.realms().getSSLContext(name);
        if (sslContext == null) {
            throw Server.log.unknownSecurityDomain(name);
        }
        return sslContext;
    }

    public void applySocketBinding(String bingingName, ProtocolServerConfigurationBuilder builder) {
        if (!this.socketBindings.exists(bingingName)) {
            throw Server.log.unknownSocketBinding(bingingName);
        }
        SocketBinding socketBinding = this.socketBindings.getSocketBinding(bingingName);
        String host = socketBinding.getAddress().getAddress().getHostAddress();
        int port = socketBinding.getPort();
        if (builder != this.endpoint && this.endpoint.host().equals(host) && this.endpoint.port() == port) {
            throw Server.log.protocolCannotUseSameSocketBindingAsEndpoint();
        }
        builder.host(host).port(port);
    }
}

