/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.LogManager;
import org.infinispan.Version;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.Server;
import org.infinispan.server.ShutdownHook;
import org.infinispan.server.logging.Messages;
import org.infinispan.server.tool.Main;

public class Bootstrap
extends Main {
    private final ExitHandler exitHandler;
    private File configurationFile;

    public Bootstrap(PrintStream stdOut, PrintStream stdErr, ExitHandler exitHandler, Properties properties) {
        super(stdOut, stdErr, properties);
        this.exitHandler = exitHandler;
    }

    public static void main(String[] args) {
        Bootstrap bootstrap = new Bootstrap(System.out, System.err, new DefaultExitHandler(), System.getProperties());
        bootstrap.run(args);
    }

    @Override
    protected void handleArgumentCommand(String command, String parameter, Iterator<String> args) {
        switch (command) {
            case "-c": {
                parameter = args.next();
            }
            case "--server-config": {
                this.configurationFile = new File(parameter);
                break;
            }
            case "-s": {
                parameter = args.next();
            }
            case "--server-root": {
                this.serverRoot = new File(parameter);
                break;
            }
            case "-b": {
                parameter = args.next();
            }
            case "--bind-address": {
                this.properties.setProperty("infinispan.bind.address", parameter);
                break;
            }
            case "-p": {
                parameter = args.next();
            }
            case "--bind-port": {
                this.properties.setProperty("infinispan.bind.port", parameter);
                break;
            }
            case "-n": {
                parameter = args.next();
            }
            case "--node-name": {
                this.properties.setProperty("infinispan.node.name", parameter);
                break;
            }
            case "-g": {
                parameter = args.next();
            }
            case "--cluster-name": {
                this.properties.setProperty("infinispan.cluster.name", parameter);
                break;
            }
            case "-o": {
                parameter = args.next();
            }
            case "--port-offset": {
                this.properties.setProperty("infinispan.socket.binding.port-offset", parameter);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void runInternal() {
        File confDir = new File(this.serverRoot, "conf");
        if (this.configurationFile == null) {
            this.configurationFile = new File(confDir, "infinispan.xml");
        } else if (!this.configurationFile.isAbsolute()) {
            this.configurationFile = Paths.get(confDir.getPath(), this.configurationFile.getPath()).toFile();
        }
        File logDir = new File(this.serverRoot, "log");
        this.properties.putIfAbsent("infinispan.server.log.path", logDir.getAbsolutePath());
        try (FileInputStream is = new FileInputStream(new File(confDir, "logging.properties"));){
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException e) {
            this.stdErr.printf("Could not load logging.properties: %s", e.getMessage());
            e.printStackTrace(this.stdErr);
        }
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(this.exitHandler));
            Server.log.serverStarting(Version.getBrandName());
            Server.log.serverConfiguration(this.configurationFile.getAbsolutePath());
            Server server = new Server(this.serverRoot, this.configurationFile, this.properties);
            server.setExitHandler(this.exitHandler);
            server.run().get();
        }
        catch (Exception e) {
            Server.log.fatal("Error", e);
        }
    }

    @Override
    public void help(PrintStream out) {
        out.printf("Usage:\n", new Object[0]);
        out.printf("  -b, --bind-address=<address>  %s\n", Messages.MSG.serverHelpBindAddress());
        out.printf("  -c, --server-config=<config>  %s\n", Messages.MSG.serverHelpServerConfig("infinispan.xml"));
        out.printf("  -h, --help                    %s\n", Messages.MSG.toolHelpHelp());
        out.printf("  -g, --cluster-name=<name>     %s\n", Messages.MSG.serverHelpClusterName("cluster"));
        out.printf("  -j, --cluster-stack=<name>    %s\n", Messages.MSG.serverHelpClusterStack("tcp"));
        out.printf("  -n, --node-name=<name>        %s\n", Messages.MSG.serverHelpNodeName());
        out.printf("  -o, --port-offset=<offset>    %s\n", Messages.MSG.serverHelpPortOffset());
        out.printf("  -p, --bind-port=<port>        %s\n", Messages.MSG.serverHelpBindPort(11222));
        out.printf("  -s, --server-root=<path>      %s\n", Messages.MSG.toolHelpServerRoot("server"));
        out.printf("  -v, --version                 %s\n", Messages.MSG.toolHelpVersion());
        out.printf("  -D<name>=<value>              %s\n", Messages.MSG.serverHelpProperty());
    }

    @Override
    public void version(PrintStream out) {
        out.printf("%s Server %s (%s)\n", Version.getBrandName(), Version.getVersion(), Version.getCodename());
    }
}

