/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.hotrod.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import java.util.Optional;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.Log;
import org.infinispan.server.router.router.impl.hotrod.handlers.SniRouteHandler;
import org.infinispan.server.router.router.impl.hotrod.handlers.util.SslUtils;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.SniRouteSource;

public class SniHandlerInitializer
extends ChannelInitializer<Channel> {
    private final RoutingTable routingTable;

    public SniHandlerInitializer(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    protected void initChannel(Channel channel) {
        SslContext defaultContext = SslUtils.INSTANCE.toNettySslContext(Optional.empty());
        DomainWildcardMappingBuilder domainMappingBuilder = new DomainWildcardMappingBuilder((Object)defaultContext);
        this.routingTable.streamRoutes(SniRouteSource.class, RouteDestination.class).map(r -> (SniRouteSource)r.getRouteSource()).forEach(r -> domainMappingBuilder.add(r.getSniHostName(), (Object)SslUtils.INSTANCE.toNettySslContext(Optional.of(r.getSslContext()))));
        Mapping domainNameMapping = domainMappingBuilder.build();
        Log.SERVER.debugf("Using SNI Handler with domain mapping %s", domainNameMapping);
        channel.pipeline().addLast(new ChannelHandler[]{new SniRouteHandler((Mapping<String, SslContext>)domainNameMapping, this.routingTable)});
    }
}

