/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import java.util.Collection;
import java.util.Set;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.NestedResponseSerializer;
import org.infinispan.server.resp.serialization.SerializationHint;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufResponseWriter;

final class ByteBufCollectionSerializer {
    ByteBufCollectionSerializer() {
    }

    private static void serialize(Collection<?> objects, ByteBufPool alloc, byte symbol, SerializationHint.SimpleHint hint) {
        ByteBufResponseWriter writer = new ByteBufResponseWriter(alloc);
        writer.writeNumericPrefix(symbol, objects.size());
        for (Object object : objects) {
            hint.serialize(object, writer);
        }
    }

    static final class SetSerializer
    implements NestedResponseSerializer<Set<?>, ByteBufPool, SerializationHint.SimpleHint> {
        static final SetSerializer INSTANCE = new SetSerializer();

        SetSerializer() {
        }

        public void accept(Set<?> objects, ByteBufPool alloc, SerializationHint.SimpleHint hint) {
            ByteBufCollectionSerializer.serialize(objects, alloc, (byte)126, hint);
        }

        @Override
        public boolean test(Object object) {
            return object instanceof Set;
        }
    }

    static final class ArraySerializer
    implements NestedResponseSerializer<Collection<?>, ByteBufPool, SerializationHint.SimpleHint> {
        static final ArraySerializer INSTANCE = new ArraySerializer();

        ArraySerializer() {
        }

        public void accept(Collection<?> objects, ByteBufPool alloc, SerializationHint.SimpleHint hint) {
            ByteBufCollectionSerializer.serialize(objects, alloc, (byte)42, hint);
        }

        @Override
        public boolean test(Object object) {
            return object instanceof Collection;
        }
    }
}

