/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.server.resp.json.JsonNumOpFunction;
import org.infinispan.util.function.SerializableFunction;

public class JsonNumIncrOpFunction
extends JsonNumOpFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Number>> {
    public static final AdvancedExternalizer<JsonNumIncrOpFunction> EXTERNALIZER = new Externalizer();

    public JsonNumIncrOpFunction(byte[] path, byte[] increment) {
        super(path, increment);
    }

    @Override
    protected Number operate(JsonNode numNode, JsonNode incrNode) {
        if (numNode.isDouble() || incrNode.isDouble()) {
            return numNode.doubleValue() + incrNode.doubleValue();
        }
        if (numNode.isFloat() || incrNode.isFloat()) {
            return Float.valueOf(numNode.floatValue() + incrNode.floatValue());
        }
        if (numNode.isLong() || incrNode.isLong()) {
            return numNode.longValue() + incrNode.longValue();
        }
        if (numNode.isBigInteger() || incrNode.isBigInteger()) {
            return numNode.bigIntegerValue().add(incrNode.bigIntegerValue());
        }
        if (numNode.isBigDecimal() || incrNode.isBigDecimal()) {
            return new BigDecimal(numNode.asText()).add(new BigDecimal(incrNode.asText()));
        }
        return numNode.intValue() + incrNode.intValue();
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonNumIncrOpFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonNumIncrOpFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
            JSONUtil.writeBytes(output, object.value);
        }

        public JsonNumIncrOpFunction readObject(ObjectInput input) throws IOException {
            byte[] path = JSONUtil.readBytes(input);
            byte[] increment = JSONUtil.readBytes(input);
            return new JsonNumIncrOpFunction(path, increment);
        }

        public Set<Class<? extends JsonNumIncrOpFunction>> getTypeClasses() {
            return Collections.singleton(JsonNumIncrOpFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_NUM_INCR_BY_FUNCTION;
        }
    }
}

