/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.IntConsumer;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.commands.BaseResp3Command;
import org.infinispan.server.resp.logging.AccessData;
import org.infinispan.server.resp.logging.Tracker;

public class AccessLoggerManager
implements IntConsumer {
    private final ChannelProgressivePromise promise;
    private final Tracker tracker;
    private long start;
    private long end;

    public AccessLoggerManager(ChannelHandlerContext ctx, TimeService timeService) {
        this.promise = ctx.newProgressivePromise();
        this.tracker = new Tracker(ctx, timeService);
    }

    public void track(RespCommand req, List<byte[]> arguments) {
        if (req == null) {
            req = UnknownCommand.UNKNOWN_COMMAND;
        }
        this.tracker.track(req, arguments);
    }

    public void flush(ChannelHandlerContext ctx, ChannelFuture future, CompletionStage<?> pending) {
        assert (ctx.channel().eventLoop().inEventLoop()) : "Flush must happen from event loop";
        if (this.end > this.start) {
            long s = this.start;
            long e = this.end;
            future.addListener(ignore -> this.promise.tryProgress(s, e));
            this.start = this.end;
        }
        if (pending != null) {
            this.logCompleted(future, pending);
        }
    }

    public void register(CompletionStage<?> res) {
        if (CompletionStages.isCompletedSuccessfully(res)) {
            this.registerFinishedOperation(null);
            return;
        }
        res.whenComplete((ignore, t) -> this.registerFinishedOperation((Throwable)t));
    }

    public void close() {
        this.promise.setSuccess();
    }

    private void logCompleted(ChannelFuture future, CompletionStage<?> pending) {
        if (CompletionStages.isCompletedSuccessfully(pending)) {
            AccessData data = this.tracker.done(null);
            if (data != null) {
                data.log(future);
            }
            return;
        }
        pending.whenComplete((ignore, t) -> {
            AccessData data = this.tracker.done((Throwable)t);
            if (data != null) {
                data.log(future);
            }
        });
    }

    private void registerFinishedOperation(Throwable t) {
        AccessData data = this.tracker.done(t);
        if (data == null) {
            throw new IllegalStateException("No operation tracked!");
        }
        this.promise.addListener((GenericFutureListener)new LogProgressiveListener(data, this.end++));
    }

    @Override
    public void accept(int value) {
        this.tracker.increaseBytesRequested(value);
    }

    private static final class UnknownCommand
    extends RespCommand
    implements BaseResp3Command {
        private static final UnknownCommand UNKNOWN_COMMAND = new UnknownCommand();

        private UnknownCommand() {
            super("UNKNOWN_COMMAND", 0, 0, 0, 0);
        }

        @Override
        public long aclMask() {
            return AclCategory.FAST;
        }
    }

    private static class LogProgressiveListener
    implements ChannelProgressiveFutureListener {
        private final AccessData data;
        private final long offset;

        private LogProgressiveListener(AccessData data, long offset) {
            this.data = data;
            this.offset = offset;
        }

        public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
            if (this.offset >= progress && this.offset <= total) {
                this.data.log(future.channel().newSucceededFuture());
                future.removeListener((GenericFutureListener)this);
            }
        }

        public void operationComplete(ChannelProgressiveFuture future) {
            this.data.log((ChannelFuture)future);
        }
    }
}

