/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonObjkeysFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<List<byte[]>>> {
    public static final AdvancedExternalizer<JsonObjkeysFunction> EXTERNALIZER = new Externalizer();
    private byte[] path;

    public JsonObjkeysFunction(byte[] path) {
        this.path = path;
    }

    public List<List<byte[]>> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        Optional existing = entryView.peek();
        if (existing.isEmpty()) {
            return null;
        }
        byte[] doc = ((JsonBucket)existing.get()).value();
        ObjectMapper mapper = JSONUtil.objectMapper;
        try {
            JsonNode rootNode = mapper.readTree(RespUtil.utf8(doc));
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(RespUtil.utf8(this.path), new Predicate[0]);
            ArrayList<List<byte[]>> resultList = new ArrayList<List<byte[]>>();
            for (JsonNode jsonNode : nodeList) {
                if (jsonNode.isObject()) {
                    ObjectNode objNode = (ObjectNode)jsonNode;
                    ArrayList namesList = new ArrayList();
                    Iterator iterator = objNode.fieldNames();
                    iterator.forEachRemaining(k -> namesList.add(k.getBytes(StandardCharsets.UTF_8)));
                    resultList.add(namesList);
                    continue;
                }
                resultList.add(null);
            }
            return resultList;
        }
        catch (JsonProcessingException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonObjkeysFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonObjkeysFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
        }

        public JsonObjkeysFunction readObject(ObjectInput input) throws IOException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonObjkeysFunction(path);
        }

        public Set<Class<? extends JsonObjkeysFunction>> getTypeClasses() {
            return Collections.singleton(JsonObjkeysFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_OBJKEYS_FUNCTION;
        }
    }
}

