/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.configuration.RespAuthenticationConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.logging.Log;

public class RespAuthenticationConfigurationBuilder
extends AbstractProtocolServerConfigurationChildBuilder<RespServerConfiguration, RespAuthenticationConfigurationBuilder, RespAuthenticationConfiguration>
implements AuthenticationConfigurationBuilder<RespAuthenticationConfiguration> {
    private final AttributeSet attributes = RespAuthenticationConfiguration.attributeDefinitionSet();
    private RespAuthenticator authenticator;
    private boolean enabled;

    RespAuthenticationConfigurationBuilder(ProtocolServerConfigurationBuilder builder) {
        super((ProtocolServerConfigurationChildBuilder)builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RespAuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public RespAuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public RespAuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RespAuthenticationConfigurationBuilder securityRealm(String realm) {
        this.attributes.attribute(RespAuthenticationConfiguration.SECURITY_REALM).set((Object)realm);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(RespAuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(RespAuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public RespAuthenticationConfigurationBuilder authenticator(RespAuthenticator authenticator) {
        this.authenticator = authenticator;
        return this.enable();
    }

    public void validate() {
        if (this.enabled && this.authenticator == null) {
            throw Log.CONFIG.authenticationWithoutAuthenticator();
        }
    }

    public RespAuthenticationConfiguration create() {
        return new RespAuthenticationConfiguration(this.attributes.protect(), this.authenticator, this.enabled);
    }

    public Builder<?> read(RespAuthenticationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public RespAuthenticationConfigurationBuilder self() {
        return this;
    }
}

