/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.pubsub;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commons.util.GlobMatcher;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.pubsub.PUBSUB;
import org.infinispan.server.resp.commands.pubsub.RespCacheListener;
import org.infinispan.server.resp.serialization.Resp3Type;

class CHANNELS
extends RespCommand
implements Resp3Command {
    private static final Predicate<byte[]> PASS_ALL = ignore -> true;

    CHANNELS() {
        super(-2, 0, 0, 0);
    }

    @Override
    public long aclMask() {
        return AclCategory.PUBSUB | AclCategory.SLOW;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CacheNotifier cn = (CacheNotifier)SecurityActions.getCacheComponentRegistry(handler.cache()).getCacheNotifier().running();
        Predicate<byte[]> filter = PASS_ALL;
        if (arguments.size() == 2) {
            filter = this.globFilter(arguments.get(1));
        }
        Collection channels = cn.getListeners().stream().filter(l -> l instanceof RespCacheListener).map(l -> (RespCacheListener)l).map(RespCacheListener::subscribedChannel).filter(Objects::nonNull).filter(filter).collect(Collectors.filtering(PUBSUB.deduplicate(), Collectors.toList()));
        handler.writer().array(channels, Resp3Type.BULK_STRING);
        return handler.myStage();
    }

    private Predicate<byte[]> globFilter(byte[] glob) {
        return channel -> GlobMatcher.match((byte[])glob, (byte[])channel);
    }
}

