/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.Authenticator;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;

public class Resp3AuthHandler
implements RespRequestHandler {
    protected final RespServer respServer;
    protected AdvancedCache<byte[], byte[]> cache;

    public Resp3AuthHandler(RespServer server) {
        this.respServer = server;
        this.cache = server.getCache();
    }

    @Override
    public RespRequestHandler handleRequest(ChannelHandlerContext ctx, String type, List<byte[]> arguments) {
        boolean success = false;
        switch (type) {
            case "HELLO": {
                byte[] respProtocolBytes = arguments.get(0);
                String version = new String(respProtocolBytes, CharsetUtil.UTF_8);
                if (!version.equals("3")) {
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-NOPROTO sorry this protocol version is not supported\r\n", ctx.alloc()));
                    break;
                }
                if (arguments.size() == 4) {
                    success = this.performAuth(ctx, arguments.get(2), arguments.get(3));
                    break;
                }
                Resp3AuthHandler.helloResponse(ctx);
                break;
            }
            case "AUTH": {
                success = this.performAuth(ctx, arguments.get(0), arguments.get(1));
                break;
            }
            case "QUIT": {
                ctx.flush();
                break;
            }
            default: {
                if (this.isAuthorized()) {
                    RespRequestHandler.super.handleRequest(ctx, type, arguments);
                    break;
                }
                this.handleUnauthorized(ctx);
            }
        }
        return success ? this.respServer.newHandler() : this;
    }

    private boolean performAuth(ChannelHandlerContext ctx, byte[] username, byte[] password) {
        return this.performAuth(ctx, new String(username, StandardCharsets.UTF_8), new String(password, StandardCharsets.UTF_8));
    }

    private boolean performAuth(ChannelHandlerContext ctx, String username, String password) {
        Authenticator authenticator = ((RespServerConfiguration)this.respServer.getConfiguration()).authentication().authenticator();
        if (authenticator == null) {
            return this.handleAuthResponse(ctx, null);
        }
        CompletionStage<Boolean> cs = authenticator.authenticate(username, password.toCharArray()).thenApply(r -> this.handleAuthResponse(ctx, (Subject)r)).exceptionally(t -> {
            this.handleUnauthorized(ctx);
            return false;
        });
        try {
            return (Boolean)CompletableFutures.await(cs.toCompletableFuture());
        }
        catch (InterruptedException | ExecutionException e) {
            Resp3Handler.handleThrowable(ctx, e);
            return false;
        }
    }

    private boolean handleAuthResponse(ChannelHandlerContext ctx, Subject subject) {
        if (subject == null) {
            ctx.writeAndFlush((Object)ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR Client sent AUTH, but no password is set\r\n", ctx.alloc())));
            return false;
        }
        this.cache = this.cache.withSubject(subject);
        ctx.writeAndFlush((Object)Resp3Handler.statusOK());
        return true;
    }

    private void handleUnauthorized(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-WRONGPASS invalid username-password pair or user is disabled.\r\n", ctx.alloc()));
    }

    private boolean isAuthorized() {
        return this.getClass() != Resp3AuthHandler.class;
    }

    private static void helloResponse(ChannelHandlerContext ctx) {
        String versionString = Version.getBrandVersion();
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("%7\r\n$6\r\nserver\r\n$15\r\nInfinispan RESP\r\n$7\r\nversion\r\n$" + versionString.length() + "\r\n" + versionString + "\r\n$5\r\nproto\r\n:3\r\n$2\r\nid\r\n:184\r\n$4\r\nmode\r\n$7\r\ncluster\r\n$4\r\nrole\r\n$6\r\nmaster\r\n$7\r\nmodules\r\n*0\r\n", ctx.alloc()));
    }
}

