/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.infinispan.server.core.ProtocolDetector;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.core.transport.CacheInitializeInboundAdapter;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;

public class MemcachedAutoDetector
extends ProtocolDetector {
    public static final String NAME = "memcached-auto-detector";

    public MemcachedAutoDetector(MemcachedServer server) {
        super((ProtocolServer)server);
    }

    public String getName() {
        return NAME;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 1) {
            return;
        }
        byte b = in.getByte(in.readerIndex());
        this.trimPipeline(ctx);
        MemcachedProtocol protocol = b == -128 ? MemcachedProtocol.BINARY : MemcachedProtocol.TEXT;
        MemcachedBaseDecoder decoder = (MemcachedBaseDecoder)((MemcachedServer)this.server).getDecoder(protocol);
        ctx.pipeline().replace((ChannelHandler)this, "decoder", (ChannelHandler)decoder);
        ((MemcachedServer)this.server).installMemcachedInboundHandler(ctx.channel(), decoder);
        Log.SERVER.tracef("Detected %s connection", (Object)protocol);
        ctx.pipeline().fireUserEventTriggered((Object)AccessControlFilter.EVENT);
        ctx.pipeline().fireUserEventTriggered(CacheInitializeInboundAdapter.CACHE_INITIALIZE_EVENT);
    }
}

