/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

public enum BinaryCommand {
    GET(0),
    SET(1),
    ADD(2),
    REPLACE(3),
    DELETE(4),
    INCREMENT(5),
    DECREMENT(6),
    QUIT(7),
    FLUSH(8),
    GETQ(9),
    NO_OP(10),
    VERSION(11),
    GETK(12),
    GETKQ(13),
    APPEND(14),
    PREPEND(15),
    STAT(16),
    SETQ(17),
    ADDQ(18),
    REPLACEQ(19),
    DELETEQ(20),
    INCREMENTQ(21),
    DECREMENTQ(22),
    QUITQ(23),
    FLUSHQ(24),
    APPENDQ(25),
    PREPENDQ(26),
    VERBOSITY(27),
    TOUCH(28),
    GAT(29),
    GATQ(30),
    SASL_LIST_MECHS(32),
    SASL_AUTH(33),
    SASL_STEP(34),
    GATK(35),
    GATKQ(36),
    CONFIG_GET(96);

    private final byte opCode;
    static final BinaryCommand[] ALL;

    private BinaryCommand(int opCode) {
        this.opCode = (byte)opCode;
    }

    public byte opCode() {
        return this.opCode;
    }

    public static BinaryCommand fromOpCode(byte opCode) {
        return ALL[opCode];
    }

    static {
        ALL = new BinaryCommand[97];
        BinaryCommand[] binaryCommandArray = BinaryCommand.values();
        int n = binaryCommandArray.length;
        for (int i = 0; i < n; ++i) {
            BinaryCommand op;
            BinaryCommand.ALL[op.opCode] = op = binaryCommandArray[i];
        }
    }
}

