/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.text.TextCommand;

public class TextHeader
extends Header {
    private final TextCommand op;
    private final byte[] key;

    public TextHeader(int requestBytes, Temporal requestStart, String principalName, byte[] key, TextCommand op) {
        super(requestStart, requestBytes, principalName);
        this.key = key;
        this.op = op;
    }

    @Override
    public Object getKey() {
        if (this.key == null) {
            return null;
        }
        return new String(this.key, StandardCharsets.US_ASCII);
    }

    @Override
    public String getOp() {
        return this.op.name();
    }

    @Override
    public String getProtocol() {
        return "MCTXT";
    }
}

