/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.counter.response.RecoveryTestResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.ClientAddress;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.CreateStateFunction;
import org.infinispan.server.hotrod.tx.table.functions.PreparingDecisionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetCompletedTransactionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetDecisionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetPreparedFunction;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.AbstractDelegatingRpcManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.tx.TxReaperAndRecoveryTest")
public class TxReaperAndRecoveryTest
extends HotRodMultiNodeTest {
    private static final AtomicInteger XID_GENERATOR = new AtomicInteger(1);
    private final ControlledTimeService timeService = new ControlledTimeService(0L);

    private static DummyXid newXid() {
        return new DummyXid(XID_GENERATOR.getAndIncrement());
    }

    private static Address newAddress() {
        return PersistentUUID.randomUUID();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        ConfigurationBuilder builder = TxReaperAndRecoveryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true);
            ((GlobalTxTable)TestingUtil.extractGlobalComponent((CacheContainer)cm, GlobalTxTable.class)).stop();
        }
    }

    public void testCleanup() throws InterruptedException {
        DummyXid xid1 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid2 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid3 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid4 = TxReaperAndRecoveryTest.newXid();
        this.initGlobalTxTable(0, xid1, null, false, Status.COMMITTED);
        this.initGlobalTxTable(1, xid2, null, false, Status.ROLLED_BACK);
        this.initGlobalTxTable(1, xid3, TxReaperAndRecoveryTest.newAddress(), false, Status.COMMITTED);
        this.initGlobalTxTable(1, xid4, TxReaperAndRecoveryTest.newAddress(), false, Status.ROLLED_BACK);
        this.assertStatus(false, false, xid1, xid2, xid3, xid4);
        this.timeService.advance(1L);
        this.assertStatus(false, false, xid1, xid2, xid3, xid4);
        this.globalTxTable(0).run();
        Thread.sleep(1000L);
        this.timeService.advance(1L);
        this.assertStatus(true, false, xid1, xid2, xid3, xid4);
        this.globalTxTable(0).run();
        this.eventually(() -> this.checkNotExists(xid1, xid3, xid4));
        this.assertStatus(true, false, xid2);
        this.globalTxTable(1).run();
        this.eventually(() -> this.checkNotExists(xid2));
        AssertJUnit.assertTrue((boolean)this.globalTxTable(0).isEmpty());
    }

    public void testRollbackIdleTransactions() throws RollbackException, SystemException {
        DummyXid xid1 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid2 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid3 = TxReaperAndRecoveryTest.newXid();
        this.initGlobalTxTable(0, xid1, null, false, Status.ACTIVE);
        this.initGlobalTxTable(1, xid2, null, false, Status.PREPARING);
        this.initGlobalTxTable(1, xid3, TxReaperAndRecoveryTest.newAddress(), false, Status.PREPARED);
        this.assertStatus(false, false, xid1, xid2, xid3);
        this.timeService.advance(2L);
        this.assertStatus(true, false, xid1, xid2, xid3);
        EmbeddedTransaction tx1 = this.newTx((Xid)((Object)xid1));
        LoggingSynchronization sync = new LoggingSynchronization();
        tx1.registerSynchronization((Synchronization)sync);
        this.perCacheTxTable(0).createLocalTx((Xid)((Object)xid1), tx1);
        LoggingRpcManager rpcManager0 = this.rpcManager();
        rpcManager0.queue.clear();
        this.globalTxTable(0).run();
        this.eventually(() -> "rolled_back".equals(sync.queue.poll()));
        this.eventually(() -> "rollback".equals(rpcManager0.queue.poll()));
        this.eventually(() -> this.getState(xid1) == null);
        this.eventually(() -> this.getState(xid3).getStatus() == Status.ROLLED_BACK);
        EmbeddedTransaction tx2 = this.newTx((Xid)((Object)xid2));
        sync.queue.clear();
        tx2.registerSynchronization((Synchronization)sync);
        this.perCacheTxTable(1).createLocalTx((Xid)((Object)xid2), tx2);
        this.globalTxTable(1).run();
        this.eventually(() -> "rolled_back".equals(sync.queue.poll()));
        this.eventually(() -> this.getState(xid2) == null);
        this.assertStatus(false, false, xid3);
        this.timeService.advance(2L);
        this.globalTxTable(0).run();
        this.eventually(() -> this.globalTxTable(0).isEmpty());
    }

    public void testPartialCompletedTransactions() throws RollbackException, SystemException {
        DummyXid xid1 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid2 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid3 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid4 = TxReaperAndRecoveryTest.newXid();
        this.initGlobalTxTable(0, xid1, null, false, Status.MARK_COMMIT);
        this.initGlobalTxTable(1, xid2, null, false, Status.MARK_ROLLBACK);
        this.initGlobalTxTable(1, xid3, TxReaperAndRecoveryTest.newAddress(), false, Status.MARK_COMMIT);
        this.initGlobalTxTable(1, xid4, TxReaperAndRecoveryTest.newAddress(), false, Status.MARK_ROLLBACK);
        this.assertStatus(false, false, xid1, xid2, xid3, xid4);
        this.timeService.advance(2L);
        this.assertStatus(true, false, xid1, xid2, xid3, xid4);
        EmbeddedTransaction tx1 = this.newTx((Xid)((Object)xid1));
        LoggingSynchronization sync = new LoggingSynchronization();
        tx1.registerSynchronization((Synchronization)sync);
        this.perCacheTxTable(0).createLocalTx((Xid)((Object)xid1), tx1);
        LoggingRpcManager rpcManager0 = this.rpcManager();
        rpcManager0.queue.clear();
        this.globalTxTable(0).run();
        this.eventually(() -> "committed".equals(sync.queue.poll()));
        this.eventuallyEquals(2, rpcManager0.queue::size);
        HashSet actual = new HashSet(rpcManager0.queue);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("rollback", "prepare"));
        AssertJUnit.assertEquals(actual, expected);
        this.eventually(() -> this.getState(xid1) == null);
        this.eventually(() -> this.getState(xid3).getStatus() == Status.COMMITTED);
        this.eventually(() -> this.getState(xid4).getStatus() == Status.ROLLED_BACK);
        EmbeddedTransaction tx2 = this.newTx((Xid)((Object)xid2));
        sync.queue.clear();
        tx2.registerSynchronization((Synchronization)sync);
        this.perCacheTxTable(1).createLocalTx((Xid)((Object)xid2), tx2);
        this.globalTxTable(1).run();
        this.eventually(() -> "rolled_back".equals(sync.queue.poll()));
        this.eventually(() -> this.getState(xid2) == null);
        this.assertStatus(false, false, xid3, xid4);
        this.timeService.advance(2L);
        this.globalTxTable(0).run();
        this.eventually(() -> this.globalTxTable(0).isEmpty());
    }

    public void testRecovery() {
        DummyXid xid1 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid2 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid3 = TxReaperAndRecoveryTest.newXid();
        DummyXid xid4 = TxReaperAndRecoveryTest.newXid();
        this.initGlobalTxTable(0, xid1, null, true, Status.PREPARED);
        this.initGlobalTxTable(1, xid2, null, true, Status.PREPARED);
        this.initGlobalTxTable(1, xid3, TxReaperAndRecoveryTest.newAddress(), true, Status.PREPARED);
        this.initGlobalTxTable(1, xid4, TxReaperAndRecoveryTest.newAddress(), false, Status.PREPARING);
        this.assertStatus(false, true, xid1, xid2, xid3);
        this.assertStatus(false, false, xid4);
        this.timeService.advance(2L);
        this.assertStatus(true, true, xid1, xid2, xid3);
        this.assertStatus(true, false, xid4);
        this.globalTxTable(0).run();
        this.eventually(() -> this.getState(xid4).getStatus() == Status.ROLLED_BACK);
        AssertJUnit.assertEquals((Object)Status.PREPARED, (Object)this.getState(xid1).getStatus());
        AssertJUnit.assertEquals((Object)Status.PREPARED, (Object)this.getState(xid2).getStatus());
        AssertJUnit.assertEquals((Object)Status.PREPARED, (Object)this.getState(xid3).getStatus());
        HashSet<Object> actual = new HashSet(this.globalTxTable(0).getPreparedTransactions());
        HashSet<DummyXid> expected = new HashSet<DummyXid>(Arrays.asList(xid1, xid2, xid3));
        AssertJUnit.assertEquals(expected, actual);
        this.assertStatus(true, true, xid1, xid2, xid3);
        this.timeService.advance(2L);
        this.globalTxTable(0).run();
        this.eventually(() -> this.getState(xid4) == null);
        AssertJUnit.assertEquals((Object)Status.PREPARED, (Object)this.getState(xid1).getStatus());
        AssertJUnit.assertEquals((Object)Status.PREPARED, (Object)this.getState(xid2).getStatus());
        AssertJUnit.assertEquals((Object)Status.PREPARED, (Object)this.getState(xid3).getStatus());
        TestResponse response = this.clients().get(0).recovery();
        AssertJUnit.assertTrue((boolean)(response instanceof RecoveryTestResponse));
        actual = new HashSet<Xid>(((RecoveryTestResponse)response).getXids());
        AssertJUnit.assertEquals(expected, actual);
        for (Xid xid : expected) {
            this.clients().get(0).rollbackTx(xid);
            this.clients().get(0).forgetTx(xid);
        }
        AssertJUnit.assertTrue((boolean)this.globalTxTable(0).isEmpty());
    }

    @Override
    protected String cacheName() {
        return "tx-reaper-and-recovery";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder builder = TxReaperAndRecoveryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        return builder;
    }

    private TxState getState(XidImpl xid) {
        return this.globalTxTable(0).getState(new CacheXid(ByteString.fromString((String)this.cacheName()), xid));
    }

    private void initGlobalTxTable(int index, XidImpl xid, Address address, boolean recoverable, Status status) {
        GlobalTxTable globalTxTable = this.globalTxTable(index);
        CacheXid cacheXid = new CacheXid(ByteString.fromString((String)this.cacheName()), xid);
        ArrayList<Object> functions = new ArrayList<Object>(5);
        GlobalTransaction gtx = address == null ? this.newGlobalTransaction(this.cacheName(), index) : this.newGlobalTransaction(this.cacheName(), index, address);
        switch (status) {
            case ACTIVE: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                break;
            }
            case PREPARING: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                functions.add(new PreparingDecisionFunction(Collections.emptyList()));
                break;
            }
            case PREPARED: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                functions.add(new PreparingDecisionFunction(Collections.emptyList()));
                functions.add(new SetPreparedFunction());
                break;
            }
            case MARK_ROLLBACK: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                functions.add(new PreparingDecisionFunction(Collections.emptyList()));
                functions.add(new SetPreparedFunction());
                functions.add(new SetDecisionFunction(false));
                break;
            }
            case MARK_COMMIT: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                functions.add(new PreparingDecisionFunction(Collections.emptyList()));
                functions.add(new SetPreparedFunction());
                functions.add(new SetDecisionFunction(true));
                break;
            }
            case ROLLED_BACK: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                functions.add(new PreparingDecisionFunction(Collections.emptyList()));
                functions.add(new SetPreparedFunction());
                functions.add(new SetDecisionFunction(false));
                functions.add(new SetCompletedTransactionFunction(false));
                break;
            }
            case COMMITTED: {
                functions.add(new CreateStateFunction(gtx, recoverable, 1L));
                functions.add(new PreparingDecisionFunction(Collections.emptyList()));
                functions.add(new SetPreparedFunction());
                functions.add(new SetDecisionFunction(true));
                functions.add(new SetCompletedTransactionFunction(true));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (TxFunction txFunction : functions) {
            AssertJUnit.assertEquals((Object)Status.OK, (Object)globalTxTable.update(cacheXid, txFunction, 30000L));
        }
        AssertJUnit.assertEquals((Object)status, (Object)globalTxTable.getState(cacheXid).getStatus());
    }

    private PerCacheTxTable perCacheTxTable(int index) {
        return (PerCacheTxTable)TestingUtil.extractComponent((Cache)this.cache(index, this.cacheName()), PerCacheTxTable.class);
    }

    private EmbeddedTransaction newTx(Xid xid) {
        EmbeddedTransaction tx = new EmbeddedTransaction((EmbeddedBaseTransactionManager)EmbeddedTransactionManager.getInstance());
        tx.setXid(xid);
        return tx;
    }

    private LoggingRpcManager rpcManager() {
        RpcManager rpcManager = (RpcManager)TestingUtil.extractComponent((Cache)this.cache(0, this.cacheName()), RpcManager.class);
        if (rpcManager instanceof LoggingRpcManager) {
            return (LoggingRpcManager)rpcManager;
        }
        return (LoggingRpcManager)((Object)TestingUtil.wrapComponent((Cache)this.cache(0, this.cacheName()), RpcManager.class, x$0 -> new LoggingRpcManager((RpcManager)x$0)));
    }

    private boolean checkNotExists(DummyXid ... xids) {
        for (DummyXid xid : xids) {
            CacheXid cacheXid = new CacheXid(ByteString.fromString((String)this.cacheName()), (XidImpl)xid);
            if (this.globalTxTable(0).getState(cacheXid) == null) continue;
            return false;
        }
        return true;
    }

    private void assertStatus(boolean timeout, boolean recoverable, DummyXid ... xids) {
        GlobalTxTable globalTxTable = this.globalTxTable(0);
        for (DummyXid xid : xids) {
            CacheXid cacheXid = new CacheXid(ByteString.fromString((String)this.cacheName()), (XidImpl)xid);
            TxState state = globalTxTable.getState(cacheXid);
            AssertJUnit.assertEquals((boolean)recoverable, (boolean)state.isRecoverable());
            AssertJUnit.assertEquals((boolean)timeout, (boolean)state.hasTimedOut(this.timeService.time()));
        }
    }

    private GlobalTxTable globalTxTable(int index) {
        return (GlobalTxTable)TestingUtil.extractGlobalComponent((CacheContainer)((CacheContainer)this.cacheManagers.get(index)), GlobalTxTable.class);
    }

    private GlobalTransaction newGlobalTransaction(String cacheName, int index) {
        return this.newGlobalTransaction(cacheName, index, this.address(index));
    }

    private GlobalTransaction newGlobalTransaction(String cacheName, int index, Address address) {
        TransactionFactory factory = (TransactionFactory)TestingUtil.extractComponent((Cache)this.cache(index, cacheName), TransactionFactory.class);
        return factory.newGlobalTransaction((Address)new ClientAddress(address), false);
    }

    private static class LoggingRpcManager
    extends AbstractDelegatingRpcManager {
        private final Queue<String> queue = new LinkedBlockingQueue<String>();

        private LoggingRpcManager(RpcManager realOne) {
            super(realOne);
        }

        protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker) {
            if (command instanceof RollbackCommand) {
                this.queue.add("rollback");
            } else if (command instanceof PrepareCommand) {
                this.queue.add("prepare");
            }
            return super.performRequest(targets, command, collector, invoker);
        }
    }

    private static class LoggingSynchronization
    implements Synchronization {
        private final Queue<String> queue = new LinkedBlockingQueue<String>();

        private LoggingSynchronization() {
        }

        public void beforeCompletion() {
            this.queue.add("before");
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                this.queue.add("committed");
            } else {
                this.queue.add("rolled_back");
            }
        }
    }

    private static class DummyXid
    extends XidImpl {
        DummyXid(int id) {
            super(-123456, new byte[]{(byte)id}, new byte[]{(byte)id});
        }
    }
}

