/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.RemoteTransaction;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.CreateStateFunction;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ByteString;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.tx.TopologyChangeFunctionalTest")
public class TopologyChangeFunctionalTest
extends HotRodMultiNodeTest {
    private org.infinispan.configuration.cache.TransactionMode transactionMode;

    public Object[] factory() {
        return new Object[]{new TopologyChangeFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.NON_XA).lockingMode(LockingMode.PESSIMISTIC), new TopologyChangeFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.NON_DURABLE_XA).lockingMode(LockingMode.PESSIMISTIC), new TopologyChangeFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.FULL_XA).lockingMode(LockingMode.PESSIMISTIC)};
    }

    public TopologyChangeFunctionalTest transactionMode(org.infinispan.configuration.cache.TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    public void testNonOriginatorLeft(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.killNode(1);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testNodeJoin(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.addNewNode();
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    @Test(groups={"unstable"}, description="ISPN-8432")
    public void testOriginatorLeft(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.killNode(0);
        tx.commitAndAssert(this.clients().get(0), 0);
        tx.forget(this.clients().get(0));
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testOriginatorLeftBeforePrepare(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.killNode(0);
        GlobalTxTable transactionTable = (GlobalTxTable)TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), GlobalTxTable.class);
        CacheXid cacheXid = new CacheXid(ByteString.fromString((String)this.cacheName()), tx.getXid());
        TxState state = transactionTable.getState(cacheXid);
        transactionTable.remove(cacheXid);
        CreateStateFunction function = new CreateStateFunction(state.getGlobalTransaction(), false, 60000L);
        transactionTable.update(cacheXid, (TxFunction)function, 60000L);
        tx.prepareAndAssert(this.clients().get(0), 0);
        tx.commitAndAssert(this.clients().get(0), 0);
        tx.forget(this.clients().get(0));
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    @Override
    protected byte protocolVersion() {
        return HotRodVersion.HOTROD_27.getVersion();
    }

    @Override
    protected String cacheName() {
        return "topology-change-tx-cache";
    }

    protected String parameters() {
        return "[" + this.lockingMode + "/" + this.transactionMode + "]";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().lockingMode(this.lockingMode);
        switch (this.transactionMode) {
            case NON_XA: {
                builder.transaction().useSynchronization(true);
                break;
            }
            case NON_DURABLE_XA: {
                builder.transaction().useSynchronization(false);
                builder.transaction().recovery().disable();
                break;
            }
            case FULL_XA: {
                builder.transaction().useSynchronization(false);
                builder.transaction().recovery().enable();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builder.clustering().hash().numOwners(2);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        return builder;
    }

    @Override
    protected int nodeCount() {
        return 3;
    }

    @BeforeMethod(alwaysRun=true)
    private void checkNumberOfNodes() {
        while (this.servers().size() > this.nodeCount()) {
            this.killNode(this.servers().size() - 1);
        }
        while (this.servers().size() < this.nodeCount()) {
            this.addNewNode();
        }
    }

    private void addNewNode() {
        int nextServerPort = this.findHighestPort().orElseGet(HotRodTestingUtil::serverPort);
        HotRodServer server = this.startClusteredServer(nextServerPort += 50);
        this.servers().add(server);
        this.clients().add(this.createClient(server, this.cacheName()));
    }

    private void assertData(byte[] key, byte[] value) {
        for (HotRodClient client : this.clients()) {
            HotRodTestingUtil.assertSuccess(client.get(key, 0), value);
        }
    }

    private void assertServerTransactionTableEmpty() {
        for (Cache cache : this.caches(this.cacheName())) {
            PerCacheTxTable perCacheTxTable = (PerCacheTxTable)TestingUtil.extractComponent((Cache)cache, PerCacheTxTable.class);
            AssertJUnit.assertTrue((boolean)perCacheTxTable.isEmpty());
        }
        for (EmbeddedCacheManager cm : this.managers()) {
            GlobalTxTable globalTxTable = (GlobalTxTable)TestingUtil.extractGlobalComponent((CacheContainer)cm, GlobalTxTable.class);
            AssertJUnit.assertTrue((boolean)globalTxTable.isEmpty());
        }
    }

    private void killNode(int index) {
        HotRodTestingUtil.killClient(this.clients().remove(index));
        this.stopClusteredServer(this.servers().remove(index));
    }
}

