/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="server.hotrod.test.HotRodServerUnregisterTopologyCacheTest", groups={"functional"})
public class HotRodServerUnregisterTopologyCacheTest
extends MultipleCacheManagersTest {
    private static final int CLUSTER_SIZE = 2;
    private List<HotRodServer> hotRodServers;

    protected void createCacheManagers() throws Throwable {
        this.createCluster(HotRodServerUnregisterTopologyCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false), 2);
        this.startServers();
        this.waitForClusterToForm();
    }

    private void startServers() {
        this.hotRodServers = new ArrayList<HotRodServer>(2);
        for (int i = 0; i < 2; ++i) {
            this.hotRodServers.add(HotRodTestingUtil.startHotRodServer(this.manager(i), ServerTestingUtil.findFreePort(), HotRodTestingUtil.getDefaultHotRodConfiguration()));
        }
    }

    public void testServerUnregisterTopologyCacheOnStop() {
        for (HotRodServer server : this.hotRodServers) {
            String topologyCacheName = ((HotRodServerConfiguration)server.getConfiguration()).topologyCacheName();
            AssertJUnit.assertTrue((boolean)this.getInternalCacheNames(server).contains(topologyCacheName));
            ServerTestingUtil.killServer((AbstractProtocolServer)server);
            AssertJUnit.assertFalse((boolean)this.getInternalCacheNames(server).contains(topologyCacheName));
        }
    }

    private Set<String> getInternalCacheNames(HotRodServer server) {
        return ((InternalCacheRegistry)server.getCacheManager().getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class)).getInternalCacheNames();
    }
}

