/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.transaction.xa.Xid;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.counter.impl.TestCounterNotificationManager;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.AddClientListenerOp;
import org.infinispan.server.hotrod.test.AuthMechListOp;
import org.infinispan.server.hotrod.test.AuthOp;
import org.infinispan.server.hotrod.test.BulkGetKeysOp;
import org.infinispan.server.hotrod.test.BulkGetOp;
import org.infinispan.server.hotrod.test.ClientChannelInitializer;
import org.infinispan.server.hotrod.test.ClientHandler;
import org.infinispan.server.hotrod.test.CommitOrRollbackOp;
import org.infinispan.server.hotrod.test.ForgetTxOp;
import org.infinispan.server.hotrod.test.GetStreamOp;
import org.infinispan.server.hotrod.test.Op;
import org.infinispan.server.hotrod.test.PartialOp;
import org.infinispan.server.hotrod.test.PrepareOp;
import org.infinispan.server.hotrod.test.PutStreamOp;
import org.infinispan.server.hotrod.test.QueryOp;
import org.infinispan.server.hotrod.test.RecoveryOp;
import org.infinispan.server.hotrod.test.RemoveClientListenerOp;
import org.infinispan.server.hotrod.test.SizeOp;
import org.infinispan.server.hotrod.test.StatsOp;
import org.infinispan.server.hotrod.test.TestAuthMechListResponse;
import org.infinispan.server.hotrod.test.TestAuthResponse;
import org.infinispan.server.hotrod.test.TestBulkGetKeysResponse;
import org.infinispan.server.hotrod.test.TestBulkGetResponse;
import org.infinispan.server.hotrod.test.TestClientListener;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestQueryResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.server.hotrod.test.TestStatsResponse;
import org.infinispan.server.hotrod.test.TxWrite;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.util.KeyValuePair;
import org.testng.AssertJUnit;

public class HotRodClient {
    private static final Log log = (Log)LogFactory.getLog(HotRodClient.class, Log.class);
    static final AtomicLong idCounter = new AtomicLong();
    final String host;
    final int port;
    final String defaultCacheName;
    final int rspTimeoutSeconds;
    final byte protocolVersion;
    final SSLEngine sslEngine;
    final Channel ch;
    Map<Long, Op> idToOp = new ConcurrentHashMap<Long, Op>();
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory(TestResourceTracker.getCurrentTestShortName() + "-Client"));

    public HotRodClient(String host, int port, String defaultCacheName, int rspTimeoutSeconds, byte protocolVersion) {
        this(host, port, defaultCacheName, rspTimeoutSeconds, protocolVersion, null);
    }

    public HotRodClient(String host, int port, String defaultCacheName, int rspTimeoutSeconds, byte protocolVersion, SSLEngine sslEngine) {
        this.host = host;
        this.port = port;
        this.defaultCacheName = defaultCacheName;
        this.rspTimeoutSeconds = rspTimeoutSeconds;
        this.protocolVersion = protocolVersion;
        this.sslEngine = sslEngine;
        this.ch = this.initializeChannel();
    }

    public byte protocolVersion() {
        return this.protocolVersion;
    }

    public String defaultCacheName() {
        return this.defaultCacheName;
    }

    public TestResponse getResponse(Op op) {
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    private Channel initializeChannel() {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.eventLoopGroup);
        bootstrap.handler((ChannelHandler)new NettyInitializers(new NettyInitializer[]{new ClientChannelInitializer(this, this.rspTimeoutSeconds, this.sslEngine, this.protocolVersion)}));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture connectFuture = bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        Channel ch = connectFuture.syncUninterruptibly().channel();
        AssertJUnit.assertTrue((boolean)connectFuture.isSuccess());
        return ch;
    }

    public Future<?> stop() {
        return this.eventLoopGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
    }

    public TestResponse put(byte[] k, int lifespan, int maxIdle, byte[] v) {
        return this.execute(160, (byte)1, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, (byte)1, 0);
    }

    public TestResponse put(byte[] k, int lifespan, int maxIdle, byte[] v, byte clientIntelligence, int topologyId) {
        return this.execute(160, (byte)1, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, clientIntelligence, topologyId);
    }

    private void assertStatus(TestResponse resp, OperationStatus expected) {
        boolean isSuccess;
        OperationStatus status = resp.getStatus();
        boolean bl = isSuccess = status == expected;
        if (resp instanceof TestErrorResponse) {
            AssertJUnit.assertTrue((String)String.format("Status should have been '%s' but instead was: '%s', and the error message was: %s", expected, status, ((TestErrorResponse)resp).msg), (boolean)isSuccess);
        } else {
            AssertJUnit.assertTrue((String)String.format("Status should have been '%s' but instead was: '%s'", expected, status), (boolean)isSuccess);
        }
    }

    private byte[] k(Method m) {
        return this.k(m, "k-");
    }

    private byte[] k(Method m, String prefix) {
        byte[] bytes = (prefix + m.getName()).getBytes();
        log.tracef("String %s is converted to %s bytes", (Object)(prefix + m.getName()), (Object)Util.printArray((byte[])bytes, (boolean)true));
        return bytes;
    }

    private byte[] v(Method m) {
        return this.v(m, "v-");
    }

    private byte[] v(Method m, String prefix) {
        return this.k(m, prefix);
    }

    public void assertPut(Method m) {
        this.assertStatus(this.put(this.k(m), 0, 0, this.v(m)), OperationStatus.Success);
    }

    public void assertPutFail(Method m) {
        Op op = new Op(160, this.protocolVersion, 1, this.defaultCacheName, this.k(m), 0, 0, this.v(m), 0, 1L, 0, 0);
        this.idToOp.put(op.id, op);
        ChannelFuture future = this.ch.writeAndFlush((Object)op);
        future.awaitUninterruptibly();
        AssertJUnit.assertFalse((boolean)future.isSuccess());
    }

    public void assertPut(Method m, String kPrefix, String vPrefix) {
        this.assertStatus(this.put(this.k(m, kPrefix), 0, 0, this.v(m, vPrefix)), OperationStatus.Success);
    }

    public void assertPut(Method m, int lifespan, int maxIdle) {
        this.assertStatus(this.put(this.k(m), lifespan, maxIdle, this.v(m)), OperationStatus.Success);
    }

    public TestResponse put(String k, String v) {
        return this.put(k.getBytes(), 0, 0, v.getBytes());
    }

    public TestResponse put(byte[] k, int lifespan, int maxIdle, byte[] v, int flags) {
        return this.execute(160, (byte)1, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, flags);
    }

    public TestResponse putIfAbsent(byte[] k, int lifespan, int maxIdle, byte[] v) {
        return this.execute(160, (byte)5, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, (byte)1, 0);
    }

    public TestResponse putIfAbsent(byte[] k, int lifespan, int maxIdle, byte[] v, int flags) {
        return this.execute(160, (byte)5, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, flags);
    }

    public TestResponse replace(byte[] k, int lifespan, int maxIdle, byte[] v) {
        return this.execute(160, (byte)7, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, (byte)1, 0);
    }

    public TestResponse replace(byte[] k, int lifespan, int maxIdle, byte[] v, int flags) {
        return this.execute(160, (byte)7, this.defaultCacheName, k, lifespan, maxIdle, v, 0L, flags);
    }

    public TestResponse replaceIfUnmodified(byte[] k, int lifespan, int maxIdle, byte[] v, long dataVersion) {
        return this.execute(160, (byte)9, this.defaultCacheName, k, lifespan, maxIdle, v, dataVersion, (byte)1, 0);
    }

    public TestResponse replaceIfUnmodified(byte[] k, int lifespan, int maxIdle, byte[] v, long dataVersion, int flags) {
        return this.execute(160, (byte)9, this.defaultCacheName, k, lifespan, maxIdle, v, dataVersion, flags);
    }

    public TestResponse remove(byte[] k) {
        return this.execute(160, (byte)11, this.defaultCacheName, k, 0, 0, null, 0L, (byte)1, 0);
    }

    public TestResponse remove(byte[] k, int flags) {
        return this.execute(160, (byte)11, this.defaultCacheName, k, 0, 0, null, 0L, flags);
    }

    public TestResponse removeIfUnmodified(byte[] k, int lifespan, int maxIdle, byte[] v, long dataVersion) {
        return this.execute(160, (byte)13, this.defaultCacheName, k, lifespan, maxIdle, v, dataVersion, (byte)1, 0);
    }

    public TestResponse removeIfUnmodified(byte[] k, long dataVersion, int flags) {
        return this.execute(160, (byte)13, this.defaultCacheName, k, 0, 0, new byte[0], dataVersion, flags);
    }

    public TestResponse execute(int magic, byte code, String name, byte[] k, int lifespan, int maxIdle, byte[] v, long dataVersion, byte clientIntelligence, int topologyId) {
        Op op = new Op(magic, this.protocolVersion, code, name, k, lifespan, maxIdle, v, 0, dataVersion, clientIntelligence, topologyId);
        return this.execute(op, op.id);
    }

    public TestErrorResponse executeExpectBadMagic(int magic, byte code, String name, byte[] k, int lifespan, int maxIdle, byte[] v, long version) {
        Op op = new Op(magic, this.protocolVersion, code, name, k, lifespan, maxIdle, v, 0, version, 1, 0);
        return (TestErrorResponse)this.execute(op, 0L);
    }

    public TestErrorResponse executePartial(int magic, byte code, String name, byte[] k, int lifespan, int maxIdle, byte[] v, long version) {
        PartialOp op = new PartialOp(magic, this.protocolVersion, code, name, k, lifespan, maxIdle, v, 0, version, 1, 0);
        return (TestErrorResponse)this.execute(op, op.id);
    }

    public TestResponse execute(int magic, byte code, String name, byte[] k, int lifespan, int maxIdle, byte[] v, long dataVersion, int flags) {
        Op op = new Op(magic, this.protocolVersion, code, name, k, lifespan, maxIdle, v, flags, dataVersion, 1, 0);
        return this.execute(op, op.id);
    }

    private TestResponse execute(Op op, long expectedResponseMessageId) {
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(expectedResponseMessageId);
    }

    public boolean writeOp(Op op) {
        return this.writeOp(op, true);
    }

    public boolean writeOp(Op op, boolean assertSuccess) {
        this.idToOp.put(op.id, op);
        ChannelFuture future = this.ch.writeAndFlush((Object)op);
        future.awaitUninterruptibly();
        if (assertSuccess) {
            AssertJUnit.assertTrue((boolean)future.isSuccess());
        }
        return future.isSuccess();
    }

    public TestGetResponse get(byte[] k, int flags) {
        return (TestGetResponse)this.get((byte)3, k, flags);
    }

    public TestResponse get(String k) {
        return this.get((byte)3, k.getBytes(), 0);
    }

    public TestGetResponse assertGet(Method m) {
        return this.assertGet(m, 0);
    }

    public TestGetResponse assertGet(Method m, int flags) {
        return this.get(this.k(m), flags);
    }

    public TestResponse containsKey(byte[] k, int flags) {
        return this.get((byte)15, k, flags);
    }

    public TestGetWithVersionResponse getWithVersion(byte[] k, int flags) {
        return (TestGetWithVersionResponse)this.get((byte)17, k, flags);
    }

    public TestGetWithMetadataResponse getWithMetadata(byte[] k, int flags) {
        return (TestGetWithMetadataResponse)this.get((byte)27, k, flags);
    }

    private TestResponse get(byte code, byte[] k, int flags) {
        Op op = new Op(160, this.protocolVersion, code, this.defaultCacheName, k, 0, 0, null, flags, 0L, 1, 0);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        if (code == 3 || code == 17 || code == 15 || code == 27) {
            return handler.getResponse(op.id);
        }
        return null;
    }

    public TestResponse clear() {
        return this.execute(160, (byte)19, this.defaultCacheName, null, 0, 0, null, 0L, (byte)1, 0);
    }

    public Map<String, String> stats() {
        StatsOp op = new StatsOp(160, this.protocolVersion, 21, this.defaultCacheName, 1, 0, null);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        TestStatsResponse resp = (TestStatsResponse)handler.getResponse(op.id);
        return resp.stats;
    }

    public TestResponse ping() {
        return this.execute(160, (byte)23, this.defaultCacheName, null, 0, 0, null, 0L, (byte)1, 0);
    }

    public TestResponse ping(byte clientIntelligence, int topologyId) {
        return this.execute(160, (byte)23, this.defaultCacheName, null, 0, 0, null, 0L, clientIntelligence, topologyId);
    }

    public TestBulkGetResponse bulkGet() {
        return this.bulkGet(0);
    }

    public TestBulkGetResponse bulkGet(int count) {
        BulkGetOp op = new BulkGetOp(160, this.protocolVersion, 25, this.defaultCacheName, 1, 0, count);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return (TestBulkGetResponse)handler.getResponse(op.id);
    }

    public TestBulkGetKeysResponse bulkGetKeys() {
        return this.bulkGetKeys(0);
    }

    public TestBulkGetKeysResponse bulkGetKeys(int scope) {
        BulkGetKeysOp op = new BulkGetKeysOp(160, this.protocolVersion, 29, this.defaultCacheName, 1, 0, scope);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return (TestBulkGetKeysResponse)handler.getResponse(op.id);
    }

    public TestQueryResponse query(byte[] query) {
        QueryOp op = new QueryOp(160, this.protocolVersion, this.defaultCacheName, 1, 0, query);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return (TestQueryResponse)handler.getResponse(op.id);
    }

    public TestAuthMechListResponse authMechList() {
        AuthMechListOp op = new AuthMechListOp(160, this.protocolVersion, 33, this.defaultCacheName, 1, 0);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return (TestAuthMechListResponse)handler.getResponse(op.id);
    }

    public TestAuthResponse auth(SaslClient sc) throws SaslException {
        byte[] saslResponse = sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : new byte[]{};
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        AuthOp op = new AuthOp(160, this.protocolVersion, 35, this.defaultCacheName, 1, 0, sc.getMechanismName(), saslResponse);
        this.writeOp(op);
        TestAuthResponse response = (TestAuthResponse)handler.getResponse(op.id);
        while (!sc.isComplete() || !response.complete) {
            saslResponse = sc.evaluateChallenge(response.challenge);
            op = new AuthOp(160, this.protocolVersion, 35, this.defaultCacheName, 1, 0, "", saslResponse);
            this.writeOp(op);
            response = (TestAuthResponse)handler.getResponse(op.id);
        }
        sc.dispose();
        return response;
    }

    public TestResponse addClientListener(TestClientListener listener, boolean includeState, Optional<KeyValuePair<String, List<byte[]>>> filterFactory, Optional<KeyValuePair<String, List<byte[]>>> converterFactory, boolean useRawData) {
        AddClientListenerOp op = new AddClientListenerOp(160, this.protocolVersion, this.defaultCacheName, 1, 0, listener.getId(), includeState, filterFactory, converterFactory, useRawData);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        handler.addClientListener(listener);
        this.writeOp(op);
        return handler.getResponse(op.id);
    }

    public TestResponse removeClientListener(byte[] listenerId) {
        RemoveClientListenerOp op = new RemoveClientListenerOp(160, this.protocolVersion, this.defaultCacheName, 1, 0, listenerId);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        this.writeOp(op);
        TestResponse response = handler.getResponse(op.id);
        if (response.getStatus() == OperationStatus.Success) {
            handler.removeClientListener(listenerId);
        }
        return response;
    }

    public TestSizeResponse size() {
        SizeOp op = new SizeOp(160, this.protocolVersion, this.defaultCacheName, 1, 0);
        boolean writeFuture = this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return (TestSizeResponse)handler.getResponse(op.id);
    }

    public TestGetWithMetadataResponse getStream(byte[] key, int offset) {
        GetStreamOp op = new GetStreamOp(160, this.protocolVersion, this.defaultCacheName, key, 0, 1, 0, offset);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return (TestGetWithMetadataResponse)handler.getResponse(op.id);
    }

    public TestResponse putStream(byte[] key, byte[] value, long version, int lifespan, int maxIdle) {
        PutStreamOp op = new PutStreamOp(160, this.protocolVersion, this.defaultCacheName, key, value, lifespan, maxIdle, version, 1, 0);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    public TestResponse prepareTx(Xid xid, boolean onePhaseCommit, Collection<TxWrite> modifications) {
        PrepareOp op = new PrepareOp(this.protocolVersion, this.defaultCacheName, 0, xid, onePhaseCommit, modifications);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    public TestResponse commitTx(Xid xid) {
        CommitOrRollbackOp op = new CommitOrRollbackOp(this.protocolVersion, this.defaultCacheName, xid, true);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    public TestResponse rollbackTx(Xid xid) {
        CommitOrRollbackOp op = new CommitOrRollbackOp(this.protocolVersion, this.defaultCacheName, xid, false);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    public TestResponse forgetTx(Xid xid) {
        ForgetTxOp op = new ForgetTxOp(this.protocolVersion, xid);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    public TestResponse recovery() {
        RecoveryOp op = new RecoveryOp(this.protocolVersion);
        this.writeOp(op);
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        return handler.getResponse(op.id);
    }

    public void registerCounterNotificationManager(TestCounterNotificationManager manager) {
        ClientHandler handler = (ClientHandler)this.ch.pipeline().last();
        handler.registerCounterNotificationManager(manager);
    }
}

