/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.infinispan.server.core.telemetry.TelemetryService;

public class HotRodTelemetryService {
    private static final TextMapGetter<Map<String, byte[]>> MAP_TEXT_MAP_GETTER = new TextMapGetter<Map<String, byte[]>>(){

        public String get(Map<String, byte[]> carrier, String key) {
            byte[] bytes = carrier.get(key);
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public Iterable<String> keys(Map<String, byte[]> carrier) {
            return carrier.keySet();
        }
    };
    private final TelemetryService telemetryService;

    public HotRodTelemetryService(TelemetryService telemetryService) {
        this.telemetryService = telemetryService;
    }

    public Span requestStart(String operationName, Map<String, byte[]> otherParams) {
        return this.telemetryService.requestStart(operationName, MAP_TEXT_MAP_GETTER, otherParams);
    }

    public void requestEnd(Object span) {
        this.telemetryService.requestEnd(span);
    }

    public void recordException(Object span, Throwable throwable) {
        this.telemetryService.recordException(span, throwable);
    }
}

