/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

public class SetCompletedTransactionFunction
extends TxFunction {
    public static final AdvancedExternalizer<SetCompletedTransactionFunction> EXTERNALIZER = new Externalizer();
    private final boolean committed;

    public SetCompletedTransactionFunction(boolean committed) {
        this.committed = committed;
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            TxState state = (TxState)view.get();
            view.set((Object)state.setStatus(this.committed ? Status.COMMITTED : Status.ROLLED_BACK, true, this.timeService), new MetaParam.Writable[0]);
            return Status.OK.value;
        }
        return Status.NO_TRANSACTION.value;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SetCompletedTransactionFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SetCompletedTransactionFunction>> getTypeClasses() {
            return Collections.singleton(SetCompletedTransactionFunction.class);
        }

        public Integer getId() {
            return 1118;
        }

        public void writeObject(ObjectOutput output, SetCompletedTransactionFunction object) throws IOException {
            output.writeBoolean(object.committed);
        }

        public SetCompletedTransactionFunction readObject(ObjectInput input) throws IOException {
            return new SetCompletedTransactionFunction(input.readBoolean());
        }
    }
}

